/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.jasper;

import com.newrelic.agent.tracers.jasper.GenerateVisitor;
import com.newrelic.agent.tracers.jasper.Node;
import com.newrelic.agent.tracers.jasper.TemplateText;
import com.newrelic.agent.tracers.jasper.Visitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JasperClassFactory {
    static final Map<ClassLoader, JasperClassFactory> classFactories = new HashMap<ClassLoader, JasperClassFactory>();
    private final Method visitTemplateTextMethod;
    private final Method templateTextGetTextMethod;
    private final Method templateTextSetTextMethod;
    private final Class<?> scriptletClass;
    private final Class<?> nodeClass;
    private final Class<?> markClass;
    private final Method generateVisitorVisitScriptletMethod;
    private Method visitorVisitScriptletMethod;
    private Method nodeGetParentMethod;
    private Method nodeGetQName;

    private JasperClassFactory(ClassLoader classloader) throws Exception {
        Class<?> generateVisitorClass = classloader.loadClass("org.apache.jasper.compiler.Generator$GenerateVisitor");
        Class<?> templateTextClass = classloader.loadClass("org.apache.jasper.compiler.Node$TemplateText");
        this.visitTemplateTextMethod = generateVisitorClass.getMethod("visit", templateTextClass);
        this.visitTemplateTextMethod.setAccessible(true);
        this.templateTextGetTextMethod = templateTextClass.getMethod("getText", new Class[0]);
        this.templateTextGetTextMethod.setAccessible(true);
        this.templateTextSetTextMethod = templateTextClass.getMethod("setText", String.class);
        this.templateTextSetTextMethod.setAccessible(true);
        this.scriptletClass = classloader.loadClass("org.apache.jasper.compiler.Node$Scriptlet");
        this.generateVisitorVisitScriptletMethod = generateVisitorClass.getMethod("visit", this.scriptletClass);
        this.generateVisitorVisitScriptletMethod.setAccessible(true);
        Class<?> visitorClass = classloader.loadClass("org.apache.jasper.compiler.Node$Visitor");
        this.visitorVisitScriptletMethod = visitorClass.getMethod("visit", this.scriptletClass);
        this.visitorVisitScriptletMethod.setAccessible(true);
        this.markClass = classloader.loadClass("org.apache.jasper.compiler.Mark");
        this.nodeClass = classloader.loadClass("org.apache.jasper.compiler.Node");
        this.nodeGetParentMethod = this.nodeClass.getMethod("getParent", new Class[0]);
        this.nodeGetParentMethod.setAccessible(true);
        this.nodeGetQName = this.nodeClass.getMethod("getQName", new Class[0]);
        this.nodeGetQName.setAccessible(true);
    }

    public Object createScriptlet(String script) throws Exception {
        Constructor<?> constructor = this.scriptletClass.getDeclaredConstructor(String.class, this.markClass, this.nodeClass);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(script, null, null);
    }

    public GenerateVisitor getGenerateVisitor(Object visitor) {
        return new GenerateVisitorImpl(visitor);
    }

    public Node getNode(Object node) {
        return new NodeImpl(node);
    }

    public Visitor getVisitor(Object visitor) {
        return new VisitorImpl(visitor);
    }

    public TemplateText getTemplateText(Object text) {
        return new TemplateTextImpl(text);
    }

    public static synchronized JasperClassFactory getJasperClassFactory(ClassLoader cl) throws Exception {
        JasperClassFactory factory = classFactories.get(cl);
        if (factory == null) {
            factory = new JasperClassFactory(cl);
            classFactories.put(cl, factory);
        }
        return factory;
    }

    private class TemplateTextImpl
    implements TemplateText {
        final Object text;

        public TemplateTextImpl(Object text) {
            this.text = text;
        }

        @Override
        public String getText() throws Exception {
            return (String)JasperClassFactory.this.templateTextGetTextMethod.invoke(this.text, new Object[0]);
        }

        @Override
        public void setText(String text) throws Exception {
            JasperClassFactory.this.templateTextSetTextMethod.invoke(this.text, text);
        }
    }

    private class GenerateVisitorImpl
    implements GenerateVisitor {
        private final Object visitor;

        public GenerateVisitorImpl(Object visitor) {
            this.visitor = visitor;
        }

        @Override
        public void visit(TemplateText text) throws Exception {
            JasperClassFactory.this.visitTemplateTextMethod.invoke(this.visitor, ((TemplateTextImpl)text).text);
        }

        @Override
        public void writeScriptlet(String script) throws Exception {
            JasperClassFactory.this.generateVisitorVisitScriptletMethod.invoke(this.visitor, JasperClassFactory.this.createScriptlet(script));
        }
    }

    private class VisitorImpl
    implements Visitor {
        private Object visitor;

        public VisitorImpl(Object visitor) {
            this.visitor = visitor;
        }

        @Override
        public void writeScriptlet(String script) throws Exception {
            JasperClassFactory.this.visitorVisitScriptletMethod.invoke(this.visitor, JasperClassFactory.this.createScriptlet(script));
        }
    }

    private class NodeImpl
    implements Node {
        private final Object node;

        public NodeImpl(Object node) {
            this.node = node;
        }

        @Override
        public Node getParent() throws Exception {
            return new NodeImpl(JasperClassFactory.this.nodeGetParentMethod.invoke(this.node, new Object[0]));
        }

        @Override
        public String getQName() throws Exception {
            return (String)JasperClassFactory.this.nodeGetQName.invoke(this.node, new Object[0]);
        }
    }
}

