/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnList;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.VarInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.analysis.Analyzer;
import com.newrelic.agent.deps.org.objectweb.asm.tree.analysis.AnalyzerException;
import com.newrelic.agent.deps.org.objectweb.asm.tree.analysis.BasicInterpreter;
import com.newrelic.agent.deps.org.objectweb.asm.tree.analysis.BasicValue;
import com.newrelic.agent.deps.org.objectweb.asm.tree.analysis.Frame;
import java.util.HashMap;
import java.util.Map;

public class ReturnInsnProcessor {
    private static final int EXPECTED_RETURN_STACK_SIZE = 1;

    public static void clearReturnStacks(String owner, MethodNode mn) {
        Map<AbstractInsnNode, Integer> stacks;
        try {
            stacks = ReturnInsnProcessor.getReturnStacks(owner, mn);
        }
        catch (AnalyzerException e) {
            return;
        }
        if (stacks != null && !stacks.isEmpty()) {
            int maxLocals;
            int nextLocalIdx = maxLocals = mn.maxLocals;
            for (Map.Entry<AbstractInsnNode, Integer> entry : stacks.entrySet()) {
                AbstractInsnNode insn = entry.getKey();
                Integer stackSize = entry.getValue();
                InsnList clearInsns = ReturnInsnProcessor.insnsBeforeReturn(insn.getOpcode(), stackSize, nextLocalIdx);
                mn.instructions.insertBefore(insn, clearInsns);
            }
            mn.maxLocals = nextLocalIdx + 1;
        }
    }

    private static InsnList insnsBeforeReturn(int opcode, int stackSize, int varIndex) {
        int load;
        int store;
        InsnList insns = new InsnList();
        switch (opcode) {
            case 176: {
                store = 58;
                load = 25;
                break;
            }
            case 172: {
                store = 54;
                load = 21;
                break;
            }
            default: {
                return insns;
            }
        }
        insns.add(new VarInsnNode(store, varIndex));
        for (int i = stackSize; i > 1; --i) {
            insns.add(new InsnNode(87));
        }
        insns.add(new VarInsnNode(load, varIndex));
        return insns;
    }

    private static Map<AbstractInsnNode, Integer> getReturnStacks(String owner, MethodNode method) throws AnalyzerException {
        BasicInterpreter interpreter = new BasicInterpreter();
        Analyzer<BasicValue> a = new Analyzer<BasicValue>(interpreter);
        Frame<BasicValue>[] frames = a.analyze(owner, method);
        HashMap<AbstractInsnNode, Integer> rtStacks = new HashMap<AbstractInsnNode, Integer>();
        for (int j = 0; j < method.instructions.size(); ++j) {
            Frame<BasicValue> f;
            AbstractInsnNode insn = method.instructions.get(j);
            if (insn.getOpcode() != 172 && insn.getOpcode() != 176 || (f = frames[j]) == null || f.getStackSize() <= 1) continue;
            rtStacks.put(insn, f.getStackSize());
        }
        return rtStacks;
    }
}

