/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.kotlincoroutines;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigListener;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.KotlinCoroutinesConfig;
import com.newrelic.agent.kotlincoroutines.CoroutineConfigListener;
import com.newrelic.agent.kotlincoroutines.SuspendsConfigListener;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import java.util.LinkedHashSet;
import java.util.Set;

public class KotlinCoroutinesService
extends AbstractService
implements AgentConfigListener {
    private final Set<CoroutineConfigListener> listeners = new LinkedHashSet<CoroutineConfigListener>();
    private final Set<SuspendsConfigListener> suspendListeners = new LinkedHashSet<SuspendsConfigListener>();
    private KotlinCoroutinesConfig coroutinesConfig;

    public KotlinCoroutinesService(KotlinCoroutinesConfig coroutinesConfig) {
        super("KotlinCoroutinesService");
        this.coroutinesConfig = coroutinesConfig;
        ServiceFactory.getConfigService().addIAgentConfigListener(this);
    }

    public void addCoroutineConfigListener(CoroutineConfigListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
            listener.configureContinuationIgnores(this.coroutinesConfig.getIgnoredContinuations(), this.coroutinesConfig.getIgnoredRegExContinuations());
            listener.configureScopeIgnores(this.coroutinesConfig.getIgnoredScopes(), this.coroutinesConfig.getIgnoredRegexScopes());
            listener.configureDispatchedTasksIgnores(this.coroutinesConfig.getIgnoredDispatched(), this.coroutinesConfig.getIgnoredRegexDispatched());
            listener.configureDelay(this.coroutinesConfig.isDelayedEnabled());
        }
    }

    public void addSuspendsConfigListener(SuspendsConfigListener listener) {
        if (listener != null) {
            this.suspendListeners.add(listener);
            listener.configureSuspendsIgnores(this.coroutinesConfig.getIgnoredSuspends(), this.coroutinesConfig.getIgnoredRegexSuspends());
        }
    }

    @Override
    protected void doStart() throws Exception {
        for (CoroutineConfigListener listener : this.listeners) {
            listener.configureDelay(this.coroutinesConfig.isDelayedEnabled());
            listener.configureScopeIgnores(this.coroutinesConfig.getIgnoredScopes(), this.coroutinesConfig.getIgnoredRegexScopes());
            listener.configureDispatchedTasksIgnores(this.coroutinesConfig.getIgnoredDispatched(), this.coroutinesConfig.getIgnoredRegexDispatched());
            listener.configureContinuationIgnores(this.coroutinesConfig.getIgnoredContinuations(), this.coroutinesConfig.getIgnoredRegExContinuations());
        }
    }

    @Override
    protected void doStop() throws Exception {
        ConfigService configService = ServiceFactory.getConfigService();
        configService.removeIAgentConfigListener(this);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void configChanged(String appName, AgentConfig agentConfig) {
        this.coroutinesConfig = agentConfig.getKotlinCoroutinesConfig();
        for (CoroutineConfigListener coroutineConfigListener : this.listeners) {
            coroutineConfigListener.configureDelay(this.coroutinesConfig.isDelayedEnabled());
            coroutineConfigListener.configureScopeIgnores(this.coroutinesConfig.getIgnoredScopes(), this.coroutinesConfig.getIgnoredRegexScopes());
            coroutineConfigListener.configureDispatchedTasksIgnores(this.coroutinesConfig.getIgnoredDispatched(), this.coroutinesConfig.getIgnoredRegexDispatched());
            coroutineConfigListener.configureContinuationIgnores(this.coroutinesConfig.getIgnoredContinuations(), this.coroutinesConfig.getIgnoredRegExContinuations());
        }
        for (SuspendsConfigListener suspendsConfigListener : this.suspendListeners) {
            suspendsConfigListener.configureSuspendsIgnores(this.coroutinesConfig.getIgnoredSuspends(), this.coroutinesConfig.getIgnoredRegexSuspends());
        }
    }
}

