/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class LazyAtomicReference<T> {
    private final AtomicReference<T> value = new AtomicReference();
    private final Callable<T> initializer;

    public LazyAtomicReference(Callable<T> initializer) {
        this.initializer = initializer;
    }

    public T get() {
        T result = this.value.get();
        if (result != null) {
            return result;
        }
        this.initializeAtomically();
        return this.value.get();
    }

    public void set(T newValue) {
        if (newValue == null) {
            throw new NullPointerException("value may not be null");
        }
        this.value.set(newValue);
    }

    private void initializeAtomically() {
        T proposedInitialValue;
        try {
            proposedInitialValue = this.initializer.call();
        }
        catch (Exception e) {
            throw new RuntimeException("exception in lazy initializer", e);
        }
        if (proposedInitialValue == null) {
            throw new NullPointerException("lazy initializer returned null");
        }
        this.value.compareAndSet(null, proposedInitialValue);
    }
}

