/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.agentcontrol;

import com.newrelic.agent.Agent;
import com.newrelic.agent.agentcontrol.AgentControlIntegrationHealthClient;
import com.newrelic.agent.agentcontrol.AgentControlIntegrationUtils;
import com.newrelic.agent.agentcontrol.AgentHealth;
import com.newrelic.agent.config.AgentControlIntegrationConfig;
import com.newrelic.agent.deps.org.yaml.snakeyaml.DumperOptions;
import com.newrelic.agent.deps.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;

public class AgentControlControlIntegrationHealthFileBasedClient
implements AgentControlIntegrationHealthClient {
    private Yaml yamlWriter;
    private File healthFile = null;
    private boolean isValid = false;

    public AgentControlControlIntegrationHealthFileBasedClient(AgentControlIntegrationConfig config) {
        URI locationFromConfig = config.getHealthDeliveryLocation();
        File fileFolder = this.createHealthFileFolderInstance(locationFromConfig);
        if (fileFolder != null) {
            this.healthFile = new File(fileFolder, this.generateHealthFilename());
            DumperOptions yamlDumperOptions = new DumperOptions();
            yamlDumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            yamlDumperOptions.setPrettyFlow(true);
            this.yamlWriter = new Yaml(yamlDumperOptions);
            this.isValid = true;
        }
    }

    @Override
    public void sendHealthMessage(AgentHealth agentHealth) {
        if (this.healthFile != null) {
            try {
                FileWriter fw = new FileWriter(this.healthFile);
                this.yamlWriter.dump(this.createHeathMessageMap(agentHealth), fw);
                fw.close();
                if (Agent.LOG.isFinestEnabled() && Agent.isDebugEnabled()) {
                    Agent.LOG.log(Level.FINEST, "Wrote agent control health file: {0}", this.healthFile.getAbsolutePath());
                }
            }
            catch (IOException e) {
                Agent.LOG.log(Level.WARNING, "Error writing agent control health message to file: {0}", e.getMessage());
            }
        }
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    private Map<String, Object> createHeathMessageMap(AgentHealth agentHealth) {
        LinkedHashMap<String, Object> healthMap = new LinkedHashMap<String, Object>();
        healthMap.put("entity_guid", agentHealth.getEntityGuid() == null ? "" : agentHealth.getEntityGuid());
        healthMap.put("healthy", agentHealth.isHealthy());
        healthMap.put("status", agentHealth.getCurrentStatus());
        healthMap.put("start_time_unix_nano", agentHealth.getStartTimeNanos());
        healthMap.put("status_time_unix_nano", AgentControlIntegrationUtils.getPseudoCurrentTimeNanos());
        if (!agentHealth.isHealthy()) {
            healthMap.put("last_error", agentHealth.getLastError());
        }
        return healthMap;
    }

    private File createHealthFileFolderInstance(URI location) {
        File fileFolder = null;
        if (!(location == null || (fileFolder = new File(location)).isDirectory() && fileFolder.canWrite())) {
            Agent.LOG.log(Level.WARNING, "agent_control.health.delivery_location is not a valid folder. Health messages will not be generated.  Configured location: {0}  isFolder: {1}  canWrite: {2}", fileFolder.getAbsolutePath(), fileFolder.isDirectory(), fileFolder.canWrite());
            fileFolder = null;
        }
        return fileFolder;
    }

    private String generateHealthFilename() {
        StringBuilder sb = new StringBuilder("health-").append(UUID.randomUUID().toString().replace("-", "")).append(".yml");
        return sb.toString();
    }
}

