/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.webservices;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.deps.org.objectweb.asm.AnnotationVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.ClassReader;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.instrumentation.InstrumentationType;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContext;
import com.newrelic.agent.instrumentation.tracing.TraceDetailsBuilder;
import com.newrelic.agent.util.Strings;
import com.newrelic.agent.util.asm.AnnotationDetails;
import com.newrelic.agent.util.asm.ClassStructure;
import com.newrelic.agent.util.asm.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class JakartaWebServiceVisitor
implements ClassMatchVisitorFactory {
    private static final String WEB_SERVICE_ANNOTATION_DESCRIPTOR = JakartaWebServiceVisitor.getDescriptor("jakarta.jws.WebService");

    private static String getDescriptor(String className) {
        StringBuilder buf = new StringBuilder();
        buf.append('L');
        int len = className.length();
        for (int i = 0; i < len; ++i) {
            char car = className.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
        return buf.toString();
    }

    @Override
    public ClassVisitor newClassMatchVisitor(final ClassLoader loader, Class<?> classBeingRedefined, final ClassReader reader, ClassVisitor cv, final InstrumentationContext context) {
        return new ClassVisitor(589824, cv){
            Map<Method, AnnotationDetails> methodsToInstrument;
            Map<String, String> classWebServiceAnnotationDetails;
            String webServiceAnnotationNameValue;

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (WEB_SERVICE_ANNOTATION_DESCRIPTOR.equals(desc)) {
                    this.methodsToInstrument = new HashMap<Method, AnnotationDetails>();
                    this.classWebServiceAnnotationDetails = new HashMap<String, String>();
                    try {
                        ClassStructure classStructure = ClassStructure.getClassStructure(Utils.getClassResource(loader, reader.getClassName()), 15);
                        AnnotationDetails webServiceDetails = classStructure.getClassAnnotations().get(WEB_SERVICE_ANNOTATION_DESCRIPTOR);
                        if (webServiceDetails != null) {
                            this.webServiceAnnotationNameValue = (String)webServiceDetails.getValue("name");
                            for (Method m4 : classStructure.getMethods()) {
                                Map<String, AnnotationDetails> methodAnnotations = classStructure.getMethodAnnotations(m4);
                                AnnotationDetails webMethodDetails = methodAnnotations.get(JakartaWebServiceVisitor.getDescriptor("jakarta.jws.WebMethod"));
                                if (webMethodDetails == null) continue;
                                this.methodsToInstrument.put(m4, webMethodDetails);
                            }
                        }
                    }
                    catch (Exception e) {
                        Agent.LOG.log(Level.FINEST, e.toString(), e);
                    }
                    return new WebServiceAnnotationVisitor(super.visitAnnotation(desc, visible));
                }
                return super.visitAnnotation(desc, visible);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                Method method;
                if (this.methodsToInstrument != null && this.methodsToInstrument.containsKey(method = new Method(name, desc))) {
                    String operationName;
                    AnnotationDetails webMethod = this.methodsToInstrument.get(method);
                    String className = this.classWebServiceAnnotationDetails.get("endpointInterface");
                    if (className == null) {
                        className = Type.getObjectType(reader.getClassName()).getClassName();
                    }
                    String string = operationName = webMethod == null ? name : (String)webMethod.getValue("operationName");
                    if (operationName == null) {
                        operationName = name;
                    }
                    String txName = Strings.join('/', className, operationName);
                    if (Agent.LOG.isFinerEnabled()) {
                        Agent.LOG.finer("Creating a web service tracer for " + reader.getClassName() + '.' + method + " using transaction name " + txName);
                    }
                    context.addTrace(method, TraceDetailsBuilder.newBuilder().setInstrumentationType(InstrumentationType.BuiltIn).setInstrumentationSourceName(JakartaWebServiceVisitor.class.getName()).setDispatcher(true).setWebTransaction(true).setTransactionName(TransactionNamePriority.FRAMEWORK_HIGH, false, "WebService", txName).build());
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }

            class WebServiceAnnotationVisitor
            extends AnnotationVisitor {
                public WebServiceAnnotationVisitor(AnnotationVisitor av) {
                    super(589824, av);
                }

                @Override
                public void visit(String name, Object value) {
                    if (value instanceof String) {
                        classWebServiceAnnotationDetails.put(name, (String)value);
                    }
                    super.visit(name, value);
                }
            }
        };
    }
}

