/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.tracing.samplers.Sampler;
import com.newrelic.api.agent.NewRelic;
import java.util.Map;
import java.util.logging.Level;

public class SamplerConfig
extends BaseConfig {
    public static final String SAMPLER_CONFIG_ROOT = "sampler";
    public static final String ADAPTIVE_SAMPLING_TARGET = "adaptive_sampling_target";
    public static final Integer DEFAULT_ADAPTIVE_SAMPLING_TARGET = 120;
    public static final Integer DEFAULT_ADAPTIVE_SAMPLING_PERIOD = 60;
    public static final String ROOT = "root";
    public static final String REMOTE_PARENT_SAMPLED = "remote_parent_sampled";
    public static final String REMOTE_PARENT_NOT_SAMPLED = "remote_parent_not_sampled";
    public static final String DEFAULT = "default";
    public static final String ADAPTIVE = "adaptive";
    public static final String ALWAYS_ON = "always_on";
    public static final String ALWAYS_OFF = "always_off";
    public static final String TRACE_ID_RATIO_BASED = "trace_id_ratio_based";
    public static final String DEFAULT_SAMPLER_TYPE = "adaptive";
    public static final String RATIO = "ratio";
    private final Object samplerProps;
    private final String sampler;
    private String samplerType;
    private Float samplerRatio;

    public SamplerConfig(String sampler, Map<String, Object> props, String parentRoot) {
        super(props, parentRoot + SAMPLER_CONFIG_ROOT + ".");
        this.sampler = sampler;
        this.samplerProps = this.getProperty(sampler);
        this.samplerType = this.initSamplerType();
        this.samplerRatio = this.initSamplerRatio();
        NewRelic.getAgent().getLogger().log(Level.INFO, "The " + this.sampler + " sampler was configured to use the " + this.samplerType + " sampler type" + (this.samplerRatio != null ? " with a ratio of " + this.samplerRatio : "") + ".");
    }

    public int getAdaptiveSamplingTarget() {
        return this.getProperty(ADAPTIVE_SAMPLING_TARGET, DEFAULT_ADAPTIVE_SAMPLING_TARGET);
    }

    public String getSampler() {
        return this.sampler;
    }

    public String getSamplerType() {
        return this.samplerType;
    }

    public Float getSamplerRatio() {
        return this.samplerRatio;
    }

    private String initSamplerType() {
        if (this.samplerType == null) {
            if (this.samplerProps == null) {
                this.samplerType = "adaptive";
            } else if (this.samplerProps instanceof String) {
                if (this.samplerProps.equals(ALWAYS_ON)) {
                    this.samplerType = ALWAYS_ON;
                } else if (this.samplerProps.equals(ALWAYS_OFF)) {
                    this.samplerType = ALWAYS_OFF;
                } else if (this.samplerProps.equals("adaptive")) {
                    this.samplerType = "adaptive";
                } else if (this.samplerProps.equals(TRACE_ID_RATIO_BASED)) {
                    this.samplerType = TRACE_ID_RATIO_BASED;
                } else if (this.samplerProps.equals(DEFAULT)) {
                    this.samplerType = "adaptive";
                } else {
                    this.logInvalidSamplerTypeAndSetToDefault();
                }
            } else if (this.samplerProps instanceof Map) {
                Map props = (Map)this.samplerProps;
                if (props.size() == 1) {
                    if (props.containsKey(ALWAYS_ON)) {
                        this.samplerType = ALWAYS_ON;
                    } else if (props.containsKey(ALWAYS_OFF)) {
                        this.samplerType = ALWAYS_OFF;
                    } else if (props.containsKey("adaptive")) {
                        this.samplerType = "adaptive";
                    } else if (props.containsKey(TRACE_ID_RATIO_BASED)) {
                        this.samplerType = TRACE_ID_RATIO_BASED;
                    } else if (props.containsKey(DEFAULT)) {
                        this.samplerType = "adaptive";
                    } else {
                        this.logInvalidSamplerTypeAndSetToDefault();
                    }
                } else {
                    this.logInvalidSamplerTypeAndSetToDefault();
                }
            } else {
                this.logInvalidSamplerTypeAndSetToDefault();
            }
        }
        return this.samplerType;
    }

    private void logInvalidSamplerTypeAndSetToDefault() {
        this.samplerType = "adaptive";
        NewRelic.getAgent().getLogger().log(Level.WARNING, "The " + this.sampler + " sampler was configured with an invalid sampler type. Configuring it to use the default " + "adaptive" + " sampler type.");
    }

    private Float initSamplerRatio() {
        if (this.samplerRatio == null && TRACE_ID_RATIO_BASED.equals(this.getSamplerType())) {
            Object ratioValue = this.getProperty(this.sampler + "." + TRACE_ID_RATIO_BASED + "." + RATIO);
            if (ratioValue != null) {
                if (ratioValue instanceof Number) {
                    this.samplerRatio = Float.valueOf(((Number)ratioValue).floatValue());
                    if (!Sampler.isValidTraceRatio(this.samplerRatio.floatValue())) {
                        this.logInvalidRatioAndSetToDefault(this.samplerRatio);
                    }
                } else {
                    this.logInvalidRatioAndSetToDefault(this.samplerRatio);
                }
            } else if (this.samplerProps != null && this.samplerProps instanceof Map) {
                Map traceIdRatioBasedProps = (Map)this.samplerProps;
                Object ratioObj = traceIdRatioBasedProps.get(TRACE_ID_RATIO_BASED);
                if (ratioObj instanceof Map) {
                    Map ratioProps = (Map)ratioObj;
                    ratioValue = ratioProps.get(RATIO);
                    if (ratioValue instanceof Number) {
                        this.samplerRatio = Float.valueOf(((Number)ratioValue).floatValue());
                        if (!Sampler.isValidTraceRatio(this.samplerRatio.floatValue())) {
                            this.logInvalidRatioAndSetToDefault(this.samplerRatio);
                        }
                    } else {
                        this.logInvalidRatioAndSetToDefault(ratioValue);
                    }
                } else {
                    this.logInvalidRatioAndSetToDefault("ratio value not set");
                }
            } else {
                this.logInvalidRatioAndSetToDefault("ratio not set");
            }
        }
        return this.samplerRatio;
    }

    private void logInvalidRatioAndSetToDefault(Object ratioValue) {
        this.samplerRatio = null;
        this.samplerType = "adaptive";
        NewRelic.getAgent().getLogger().log(Level.WARNING, "The " + this.sampler + " sampler was configured to use the trace_id_ratio_based sampler type with an invalid ratio: " + ratioValue + ". Configuring it to use the default " + "adaptive" + " sampler type.");
    }
}

