/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.telemetry.metrics;

import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.TelemetryBatch;
import com.newrelic.telemetry.metrics.CommonAttributesBuilder;
import com.newrelic.telemetry.metrics.Metric;
import java.util.Collection;
import java.util.Collections;

public class MetricBatch
extends TelemetryBatch<Metric> {
    public MetricBatch(Collection<Metric> metrics, Attributes commonAttributes) {
        super(metrics, commonAttributes);
    }

    @Override
    public TelemetryBatch<Metric> createSubBatch(Collection<Metric> telemetry) {
        return new MetricBatch(telemetry, this.getCommonAttributes());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Collection<Metric> metrics = Collections.emptyList();
        private CommonAttributesBuilder commonAttributesBuilder = new CommonAttributesBuilder();

        public Builder serviceName(String serviceName) {
            this.commonAttributesBuilder.serviceName(serviceName);
            return this;
        }

        public Builder instrumentationProvider(String instrumentationProvider) {
            this.commonAttributesBuilder.instrumentationProvider(instrumentationProvider);
            return this;
        }

        public Builder attributes(Attributes attributes) {
            this.commonAttributesBuilder.attributes(attributes);
            return this;
        }

        public Builder metrics(Collection<Metric> metrics) {
            this.metrics = metrics;
            return this;
        }

        public MetricBatch build() {
            Attributes attributes = this.commonAttributesBuilder.build();
            return new MetricBatch(this.metrics, attributes);
        }
    }
}

