/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr.tosummary;

import com.newrelic.jfr.tosummary.EventToSummary;
import com.newrelic.jfr.tosummary.LongSummarizer;
import com.newrelic.telemetry.Attributes;
import com.newrelic.telemetry.metrics.Summary;
import java.time.Instant;
import java.util.stream.Stream;
import jdk.jfr.consumer.RecordedEvent;

public final class PerThreadObjectAllocationOutsideTLABSummarizer
implements EventToSummary {
    public static final String JFR_OBJECT_ALLOCATION_OUTSIDE_TLAB_ALLOCATION = "jfr.ObjectAllocationOutsideTLAB.allocation";
    public static final String ALLOCATION_SIZE = "allocationSize";
    public static final String THREAD_NAME = "thread.name";
    private final String threadName;
    private final LongSummarizer summarizer;
    private long startTimeMs;
    private long endTimeMs = 0L;

    public PerThreadObjectAllocationOutsideTLABSummarizer(String threadName, long startTimeMs) {
        this(threadName, startTimeMs, new LongSummarizer(ALLOCATION_SIZE));
    }

    public PerThreadObjectAllocationOutsideTLABSummarizer(String threadName, long startTimeMs, LongSummarizer summarizer) {
        this.threadName = threadName;
        this.startTimeMs = startTimeMs;
        this.summarizer = summarizer;
    }

    @Override
    public String getEventName() {
        return "jdk.ObjectAllocationOutsideTLAB";
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.endTimeMs = ev.getStartTime().toEpochMilli();
        this.summarizer.accept(ev);
    }

    @Override
    public Stream<Summary> summarize() {
        Attributes attr = new Attributes().put(THREAD_NAME, this.threadName);
        Summary out = new Summary(JFR_OBJECT_ALLOCATION_OUTSIDE_TLAB_ALLOCATION, this.summarizer.getCount(), this.summarizer.getSum(), this.summarizer.getMin(), this.summarizer.getMax(), this.startTimeMs, this.endTimeMs, attr);
        return Stream.of(out);
    }

    @Override
    public void reset() {
        this.startTimeMs = Instant.now().toEpochMilli();
        this.endTimeMs = 0L;
        this.summarizer.reset();
    }
}

