/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.sql;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.sql.SlowQueryInfo;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.transport.DataSenderWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Map;

class SqlTraceImpl
implements SqlTrace,
JSONStreamAware {
    private final String blameMetricName;
    private final String metricName;
    private final String uri;
    private final String query;
    private final long id;
    private final int callCount;
    private final long total;
    private final long max;
    private final long min;
    private final Map<String, Object> parameters;

    public SqlTraceImpl(SlowQueryInfo info) {
        this.blameMetricName = info.getBlameMetricName();
        this.metricName = info.getMetricName();
        this.uri = info.getRequestUri();
        this.query = info.getQuery();
        this.id = info.getId();
        this.callCount = info.getCallCount();
        this.total = info.getTotalInMillis();
        this.min = info.getMinInMillis();
        this.max = info.getMaxInMillis();
        this.parameters = info.getParameters();
    }

    @Override
    public String getBlameMetricName() {
        return this.blameMetricName;
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getCallCount() {
        return this.callCount;
    }

    @Override
    public long getMax() {
        return this.max;
    }

    @Override
    public long getMin() {
        return this.min;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.blameMetricName, this.uri, this.id, this.query, this.metricName, this.callCount, this.total, this.min, this.max, this.getData(out)), out);
    }

    private Object getData(Writer out) {
        return DataSenderWriter.getJsonifiedOptionallyCompressedEncodedString(this.parameters, out, 1);
    }
}

