/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.jmx.values;

import com.newrelic.agent.jmx.metrics.BaseJmxValue;
import com.newrelic.agent.jmx.metrics.DataSourceJmxMetricGenerator;
import com.newrelic.agent.jmx.metrics.JmxFrameworkValues;
import com.newrelic.agent.jmx.metrics.JmxMetric;
import com.newrelic.agent.jmx.metrics.ServerJmxMetricGenerator;
import java.util.ArrayList;
import java.util.List;

public class ResinJmxValues
extends JmxFrameworkValues {
    public static final String PREFIX = "resin";
    private static final int METRIC_COUNT = 4;
    private static final List<BaseJmxValue> METRICS = new ArrayList<BaseJmxValue>(4);

    @Override
    public List<BaseJmxValue> getFrameworkMetrics() {
        return METRICS;
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    static {
        METRICS.add(new BaseJmxValue("resin:type=SessionManager,*", "JmxBuiltIn/Session/{WebApp}/", new JmxMetric[]{ServerJmxMetricGenerator.SESSION_ACTIVE_COUNT.createMetric("SessionActiveCount"), ServerJmxMetricGenerator.SESSION_EXPIRED_COUNT.createMetric("SessionTimeoutCountTotal")}));
        METRICS.add(new BaseJmxValue("resin:type=ConnectionPool,*", "JmxBuiltIn/DataSources/{name}/", new JmxMetric[]{DataSourceJmxMetricGenerator.CONNECTIONS_POOL_SIZE.createMetric("ConnectionCount"), DataSourceJmxMetricGenerator.CONNECTIONS_IDLE.createMetric("ConnectionIdleCount"), DataSourceJmxMetricGenerator.CONNECTIONS_ACTIVE.createMetric("ConnectionActiveCount"), DataSourceJmxMetricGenerator.CONNECTIONS_CREATED.createMetric("ConnectionCreateCountTotal"), DataSourceJmxMetricGenerator.CONNECTIONS_MAX.createMetric("MaxConnections")}));
        METRICS.add(new BaseJmxValue("resin:type=ThreadPool", "JmxBuiltIn/ThreadPool/Resin/", new JmxMetric[]{ServerJmxMetricGenerator.ACTIVE_THREAD_POOL_COUNT.createMetric("ThreadActiveCount"), ServerJmxMetricGenerator.IDLE_THREAD_POOL_COUNT.createMetric("ThreadIdleCount"), ServerJmxMetricGenerator.MAX_THREAD_POOL_COUNT.createMetric("ThreadMax")}));
        METRICS.add(new BaseJmxValue("resin:type=TransactionManager", "JmxBuiltIn/Transactions/", new JmxMetric[]{ServerJmxMetricGenerator.TRANS_ROLLED_BACK_COUNT.createMetric("RollbackCountTotal"), ServerJmxMetricGenerator.TRANS_COMMITED_COUNT.createMetric("CommitCountTotal"), ServerJmxMetricGenerator.TRANS_ACTIVE_COUNT.createMetric("TransactionCount")}));
    }
}

