/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.internal.MapEnvironmentFacade;
import com.newrelic.agent.config.internal.SystemEnvironmentFacade;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.agent.discovery.AgentArguments;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public abstract class EnvironmentFacade {
    static EnvironmentFacade getInstance() {
        String agentArgs = System.getProperty("nr-internal-agent-args");
        if (agentArgs != null) {
            try {
                AgentArguments args2 = AgentArguments.fromJsonObject(new JSONParser().parse(agentArgs));
                return new MapEnvironmentFacade(args2.getEnvironment());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            System.getenv("test");
            return new SystemEnvironmentFacade();
        }
        catch (SecurityException e) {
            Agent.LOG.log(Level.SEVERE, e, "Unable to access environment variables for configuration");
            return new MapEnvironmentFacade(Collections.emptyMap());
        }
    }

    public abstract String getenv(String var1);

    public abstract Map<String, String> getAllEnvProperties();
}

