/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.weavepackage;

import com.newrelic.weave.weavepackage.AnnotationProxyInvocationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class AnnotationProxyTemplate {
    private static AtomicReference<Annotation> ANNOTATION_PROXY = new AtomicReference();

    public static <T extends Annotation> T getOrCreateAnnotationHolder(Class clazz, Class<T> annotationClass, Object ... annotationValues) {
        if (ANNOTATION_PROXY.get() == null && clazz != null) {
            Object annotationProxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{annotationClass}, (InvocationHandler)new AnnotationProxyInvocationHandler(AnnotationProxyTemplate.annotationValuesToMap(annotationValues)));
            ANNOTATION_PROXY.compareAndSet(null, (Annotation)annotationProxy);
        }
        return (T)ANNOTATION_PROXY.get();
    }

    private static Map<String, Object> annotationValuesToMap(Object ... annotationValues) {
        HashMap<String, Object> annotationMap = new HashMap<String, Object>();
        if (annotationValues != null) {
            for (int i = 0; i < annotationValues.length; i += 2) {
                annotationMap.put((String)annotationValues[i], annotationValues[i + 1]);
            }
        }
        return annotationMap;
    }
}

