/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.util.DelegatingInstrumentation;
import com.newrelic.agent.util.UnwindableInstrumentation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class UnwindableInstrumentationImpl
extends DelegatingInstrumentation
implements UnwindableInstrumentation {
    final Map<ClassFileTransformer, ClassFileTransformer> classFileTransformerMap = new ConcurrentHashMap<ClassFileTransformer, ClassFileTransformer>();
    final Set<Class<?>> modifiedClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    final Set<ClassInfo> modifiedClassInfo = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean wrap = new AtomicBoolean(true);

    UnwindableInstrumentationImpl(Instrumentation instrumentation) {
        super(instrumentation);
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer, boolean canRetransform) {
        if (this.wrap.get() && UnwindableInstrumentationImpl.isNewRelic(transformer)) {
            super.addTransformer(this.wrap(transformer), canRetransform);
        } else {
            super.addTransformer(transformer, canRetransform);
        }
    }

    @Override
    public void addTransformer(ClassFileTransformer transformer) {
        if (this.wrap.get() && UnwindableInstrumentationImpl.isNewRelic(transformer)) {
            super.addTransformer(this.wrap(transformer));
        } else {
            super.addTransformer(transformer);
        }
    }

    @Override
    public boolean removeTransformer(ClassFileTransformer transformer) {
        if (this.wrap.get() && UnwindableInstrumentationImpl.isNewRelic(transformer)) {
            ClassFileTransformer wrapper = this.classFileTransformerMap.get(transformer);
            if (wrapper != null) {
                return super.removeTransformer(wrapper);
            }
            return super.removeTransformer(transformer);
        }
        return super.removeTransformer(transformer);
    }

    private ClassFileTransformer wrap(final ClassFileTransformer transformer) {
        ClassFileTransformer wrapper = new ClassFileTransformer(){

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                byte[] modifiedBytes = transformer.transform(loader, className, classBeingRedefined, protectionDomain, classfileBuffer);
                if (UnwindableInstrumentationImpl.this.wrap.get() && modifiedBytes != null && modifiedBytes.length != classfileBuffer.length) {
                    if (classBeingRedefined == null) {
                        UnwindableInstrumentationImpl.this.modifiedClassInfo.add(new ClassInfo(loader, className));
                    } else {
                        UnwindableInstrumentationImpl.this.modifiedClasses.add(classBeingRedefined);
                    }
                }
                return modifiedBytes;
            }
        };
        this.classFileTransformerMap.put(transformer, wrapper);
        return wrapper;
    }

    private static boolean isNewRelic(ClassFileTransformer transformer) {
        return transformer.getClass().getName().contains("newrelic");
    }

    @Override
    public void started() {
        this.wrap.set(false);
        this.modifiedClasses.clear();
        this.modifiedClassInfo.clear();
    }

    @Override
    public void unwind() {
        this.wrap.set(false);
        this.classFileTransformerMap.values().forEach(x$0 -> super.removeTransformer((ClassFileTransformer)x$0));
        this.classFileTransformerMap.clear();
        this.modifiedClassInfo.forEach(classInfo -> {
            try {
                this.modifiedClasses.add(classInfo.loadClass());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
        this.modifiedClassInfo.clear();
        if (!this.modifiedClasses.isEmpty()) {
            try {
                super.retransformClasses(this.modifiedClasses.toArray(new Class[0]));
            }
            catch (UnmodifiableClassException unmodifiableClassException) {
                // empty catch block
            }
        }
        this.modifiedClasses.clear();
    }

    public static Instrumentation wrapInstrumentation(Instrumentation instrumentation) {
        List<MethodDesc> missingInterfaceMethods = UnwindableInstrumentationImpl.getMissingInterfaceMethods();
        UnwindableInstrumentationImpl unwindableInstrumentation = new UnwindableInstrumentationImpl(instrumentation);
        if (missingInterfaceMethods.isEmpty()) {
            return unwindableInstrumentation;
        }
        return UnwindableInstrumentationImpl.createProxyInstance(unwindableInstrumentation, instrumentation, missingInterfaceMethods);
    }

    static Instrumentation createProxyInstance(UnwindableInstrumentation unwindableInstrumentation, Instrumentation instrumentation, List<MethodDesc> missingInterfaceMethods) {
        HashSet<MethodDesc> missingMethods = new HashSet<MethodDesc>(missingInterfaceMethods);
        InvocationHandler invocationHandler = (proxy, method, args2) -> {
            if (missingMethods.contains(new MethodDesc(method))) {
                return method.invoke((Object)instrumentation, args2);
            }
            return method.invoke((Object)unwindableInstrumentation, args2);
        };
        return (Instrumentation)Proxy.newProxyInstance(UnwindableInstrumentation.class.getClassLoader(), new Class[]{UnwindableInstrumentation.class}, invocationHandler);
    }

    static List<MethodDesc> getMissingInterfaceMethods() {
        List<MethodDesc> interfaceMethods = Arrays.asList(Instrumentation.class.getMethods()).stream().map(MethodDesc::new).collect(Collectors.toList());
        Arrays.asList(DelegatingInstrumentation.class.getDeclaredMethods()).stream().map(MethodDesc::new).forEach(interfaceMethods::remove);
        return interfaceMethods;
    }

    private static class ClassInfo {
        private final ClassLoader classLoader;
        private final String className;

        public ClassInfo(ClassLoader classLoader, String className) {
            this.classLoader = classLoader;
            this.className = className;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassInfo classInfo = (ClassInfo)o;
            return Objects.equals(this.classLoader, classInfo.classLoader) && this.className.equals(classInfo.className);
        }

        public int hashCode() {
            return Objects.hash(this.classLoader, this.className);
        }

        public Class<?> loadClass() throws ClassNotFoundException {
            ClassLoader classLoader = this.classLoader == null ? ClassLoader.getSystemClassLoader() : this.classLoader;
            return classLoader.loadClass(this.className);
        }
    }

    static class MethodDesc {
        private final String name;
        private final String desc;

        public MethodDesc(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }

        public MethodDesc(Method method) {
            this(method.getName(), Type.getMethodDescriptor(method));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDesc that = (MethodDesc)o;
            return this.name.equals(that.name) && this.desc.equals(that.desc);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.desc);
        }
    }
}

