/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.samplers.AbstractCPUSampler;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.weave.utils.Streams;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;

public class ProcStatCPUSampler
extends AbstractCPUSampler {
    private final File statFile;
    private final long clockTicksPerSecond;

    public ProcStatCPUSampler(File statFile) throws Exception {
        this.statFile = statFile;
        this.clockTicksPerSecond = this.getClockTicksPerSecond();
        this.readCPUStats();
    }

    private long getClockTicksPerSecond() {
        long defaultClockTicks = 100L;
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        return config.getProperty("clock_ticks_per_second", defaultClockTicks);
    }

    @Override
    protected double getProcessCpuTime() {
        try {
            CPUStats stats = this.readCPUStats();
            Agent.LOG.finest("CPU Stats " + stats);
            if (stats == null) {
                return 0.0;
            }
            return stats.getSystemTime() + stats.getUserTime();
        }
        catch (IOException e) {
            return 0.0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CPUStats readCPUStats() throws IOException {
        ByteArrayOutputStream oStream = new ByteArrayOutputStream(8192);
        String userTime = "";
        String systemTime = "";
        try (FileInputStream iStream = new FileInputStream(this.statFile);){
            Streams.copy(iStream, oStream);
            oStream.close();
            String[] stats = oStream.toString().split(" ");
            if (stats.length <= 13) return null;
            userTime = stats[13];
            systemTime = stats[14];
            CPUStats cPUStats = new CPUStats(Long.parseLong(userTime), Long.parseLong(systemTime));
            return cPUStats;
        }
        catch (NumberFormatException e) {
            Agent.LOG.fine(MessageFormat.format("Badly formatted CPU jiffies: ''{0}'' user, ''{1}'' system", userTime, systemTime));
            return null;
        }
    }

    private class CPUStats {
        private final double userTime;
        private final double systemTime;

        public CPUStats(long userTime, long systemTime) {
            this.userTime = userTime / ProcStatCPUSampler.this.clockTicksPerSecond;
            this.systemTime = systemTime / ProcStatCPUSampler.this.clockTicksPerSecond;
        }

        public double getUserTime() {
            return this.userTime;
        }

        public double getSystemTime() {
            return this.systemTime;
        }

        public String toString() {
            return "User: " + this.userTime + ", System: " + this.systemTime;
        }
    }
}

