/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.api.agent.NewRelic;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ClearExpiredLogsRunnable
implements Runnable {
    private static final String DATE_REGEX = "\\.(\\d{4}-(0[1-9]|1[012])-(0[1-9]|[12][0-9]|3[01]))(\\.\\d)?$";
    private final Pattern pattern;
    private final Path logDirectoryPath;
    private final int daysToKeepFiles;

    public ClearExpiredLogsRunnable(int fileCount, String logfile) {
        File absoluteLogFilename = new File(logfile);
        this.daysToKeepFiles = fileCount;
        this.logDirectoryPath = absoluteLogFilename.getParent() == null ? Paths.get("./", new String[0]) : Paths.get(absoluteLogFilename.getParent(), new String[0]);
        String fileNamePrefix = absoluteLogFilename.getName();
        this.pattern = Pattern.compile(fileNamePrefix.replace(".", "\\.") + DATE_REGEX);
    }

    @Override
    public void run() {
        Path logDirectory = Paths.get(this.logDirectoryPath.toString(), new String[0]);
        LocalDate thresholdDate = LocalDate.now().minusDays(this.daysToKeepFiles);
        try (Stream<Path> paths = Files.list(logDirectory);){
            paths.forEach(path -> {
                String fileName = path.getFileName().toString();
                String dateString = this.extractDateString(fileName);
                this.deleteIfOlderThanThreshold((Path)path, dateString, thresholdDate);
            });
        }
        catch (IOException e) {
            NewRelic.getAgent().getLogger().log(Level.FINEST, "Error listing log files in: " + this.logDirectoryPath, (Object)e);
        }
    }

    private void deleteIfOlderThanThreshold(Path filePath, String dateString, LocalDate thresholdDate) {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (dateString != null) {
            try {
                LocalDate fileDate = LocalDate.parse(dateString, dateFormat);
                if (fileDate.isBefore(thresholdDate)) {
                    Files.delete(filePath);
                }
            }
            catch (IOException e) {
                NewRelic.getAgent().getLogger().log(Level.FINEST, "Error deleting expired log", (Object)e);
            }
        }
    }

    private String extractDateString(String fileName) {
        Matcher matcher = this.pattern.matcher(fileName);
        return matcher.find() ? matcher.group(1) : null;
    }
}

