/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.database;

import com.newrelic.agent.database.DefaultDatabaseStatementParser;
import com.newrelic.agent.database.DefaultStatementFactory;
import com.newrelic.agent.database.ParsedDatabaseStatement;
import com.newrelic.agent.database.StatementFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class InnerSelectStatementFactory
implements StatementFactory {
    private final StatementFactory selectStatementFactory = new DefaultStatementFactory("select", DefaultDatabaseStatementParser.SELECT_PATTERN, true);
    private final Pattern innerSelectPattern = Pattern.compile("^\\s*SELECT.*?\\sFROM\\s*\\(\\s*(SELECT.*)", 34);

    InnerSelectStatementFactory() {
    }

    @Override
    public ParsedDatabaseStatement parseStatement(String statement) {
        String res2;
        String sql = statement;
        String res = null;
        while ((res2 = this.findMatch(sql)) != null) {
            res = res2;
            sql = res2;
        }
        if (res != null) {
            return this.selectStatementFactory.parseStatement(res);
        }
        return this.selectStatementFactory.parseStatement(statement);
    }

    private String findMatch(String statement) {
        Matcher matcher = this.innerSelectPattern.matcher(statement);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String getOperation() {
        return "select";
    }
}

