/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.JarCollectorConfig;
import com.newrelic.agent.config.SystemPropertyFactory;
import com.newrelic.agent.config.SystemPropertyProvider;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class JarCollectorConfigImpl
extends BaseConfig
implements JarCollectorConfig {
    public static final String ENABLED = "enabled";
    public static final String SKIP_TEMP_JARS = "skip_temp_jars";
    public static final String JARS_PER_SECOND = "jars_per_second";
    public static final boolean DEFAULT_ENABLED = Boolean.TRUE;
    public static final boolean DEFAULT_SKIP_TEMP_JARS = Boolean.TRUE;
    public static final int DEFAULT_JARS_PER_SECOND = 10;
    public static final String SYSTEM_PROPERTY_ROOT_DEPRECATED = "newrelic.config.module.";
    public static final String SYSTEM_PROPERTY_ROOT = "newrelic.config.jar_collector.";
    private static final AtomicBoolean isUsingDeprecatedConfigSettings = new AtomicBoolean(false);
    private final boolean isEnabled = this.getProperty("enabled", DEFAULT_ENABLED);
    private final boolean skipTempJars = this.getProperty("skip_temp_jars", DEFAULT_SKIP_TEMP_JARS);
    private final Integer jarsPerSecond = this.getProperty("jars_per_second", 10);

    public JarCollectorConfigImpl(Map<String, Object> pProps) {
        super(pProps, SYSTEM_PROPERTY_ROOT);
    }

    static JarCollectorConfigImpl createJarCollectorConfig(Map<String, Object> settings) {
        if (settings == null) {
            settings = Collections.emptyMap();
        }
        return new JarCollectorConfigImpl(settings);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public boolean skipTempJars() {
        return this.skipTempJars;
    }

    @Override
    public int getJarsPerSecond() {
        return this.jarsPerSecond;
    }

    @Override
    protected Object getPropertyFromSystemEnvironment(String name, Object defaultVal) {
        return this.getMergedValue(name, true);
    }

    @Override
    protected Object getPropertyFromSystemProperties(String name, Object defaultVal) {
        return this.getMergedValue(name, false);
    }

    private Object getMergedValue(String name, boolean isEnvVar) {
        Object deprecatedParsedValue;
        Object parsedValue;
        if (this.systemPropertyPrefix == null) {
            return null;
        }
        SystemPropertyProvider systemPropertyProvider = SystemPropertyFactory.getSystemPropertyProvider();
        String systemPropertyKey = this.getSystemPropertyKey(name);
        String deprecatedSystemPropertyKey = this.getDeprecatedSystemPropertyKey(name);
        if (isEnvVar) {
            parsedValue = JarCollectorConfigImpl.parseValue(systemPropertyProvider.getEnvironmentVariable(systemPropertyKey));
            deprecatedParsedValue = JarCollectorConfigImpl.parseValue(systemPropertyProvider.getEnvironmentVariable(deprecatedSystemPropertyKey));
        } else {
            parsedValue = JarCollectorConfigImpl.parseValue(systemPropertyProvider.getSystemProperty(systemPropertyKey));
            deprecatedParsedValue = JarCollectorConfigImpl.parseValue(systemPropertyProvider.getSystemProperty(deprecatedSystemPropertyKey));
        }
        if (parsedValue != null) {
            return parsedValue;
        }
        if (deprecatedParsedValue != null) {
            isUsingDeprecatedConfigSettings.set(true);
        }
        return deprecatedParsedValue;
    }

    private String getDeprecatedSystemPropertyKey(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        return SYSTEM_PROPERTY_ROOT_DEPRECATED + key;
    }

    public static boolean isUsingDeprecatedConfigSettings() {
        return isUsingDeprecatedConfigSettings.get();
    }
}

