/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.BaseConfig;
import com.newrelic.agent.config.DatastoreConfig;
import java.util.Map;

public class DatastoreConfigImpl
extends BaseConfig
implements DatastoreConfig {
    public static final String ENABLED = "enabled";
    public static final String INSTANCE_REPORTING = "instance_reporting";
    public static final boolean INSTANCE_REPORTING_DEFAULT_ENABLED = true;
    public static final String DATABASE_NAME_REPORTING = "database_name_reporting";
    public static final boolean DATABASE_NAME_REPORTING_DEFAULT_ENABLED = true;
    public static final String DATABASE_CONNECTION_METADATA = "database_connection_metadata";
    public static final boolean DATABASE_CONNECTION_METADATA_ENABLED = true;
    public static final String PROPERTY_NAME = "datastore_tracer";
    public static final String PROPERTY_ROOT = "newrelic.config.datastore_tracer.";
    public static final String DOT = ".";
    private final boolean isInstanceEnabled;
    private final boolean isDatabaseNameEnabled;
    private final boolean isDatabaseConnectionMetadataEnabled;

    public DatastoreConfigImpl(Map<String, Object> props) {
        super(props, PROPERTY_ROOT);
        BaseConfig instanceReportConfig = new BaseConfig(this.nestedProps(INSTANCE_REPORTING), "newrelic.config.datastore_tracer.instance_reporting.");
        this.isInstanceEnabled = instanceReportConfig.getProperty(ENABLED, true);
        BaseConfig databaseNameReportConfig = new BaseConfig(this.nestedProps(DATABASE_NAME_REPORTING), "newrelic.config.datastore_tracer.database_name_reporting.");
        this.isDatabaseNameEnabled = databaseNameReportConfig.getProperty(ENABLED, true);
        BaseConfig databaseConnectionMetadataConfig = new BaseConfig(this.nestedProps(DATABASE_CONNECTION_METADATA), "newrelic.config.datastore_tracer.database_connection_metadata.");
        this.isDatabaseConnectionMetadataEnabled = databaseConnectionMetadataConfig.getProperty(ENABLED, true);
    }

    @Override
    public boolean isInstanceReportingEnabled() {
        return this.isInstanceEnabled;
    }

    @Override
    public boolean isDatabaseNameReportingEnabled() {
        return this.isDatabaseNameEnabled;
    }

    @Override
    public boolean isDatabaseConnectionMetadataEnabled() {
        return this.isDatabaseConnectionMetadataEnabled;
    }
}

