/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.jfr;

import com.newrelic.agent.deps.org.slf4j.Logger;
import com.newrelic.agent.deps.org.slf4j.LoggerFactory;
import jdk.jfr.consumer.RecordedObject;

public class RecordedObjectValidators {
    private static final Logger logger = LoggerFactory.getLogger(RecordedObjectValidators.class);

    private RecordedObjectValidators() {
    }

    public static boolean hasField(RecordedObject recordedObject, String objectField, String callingClassName) {
        if (RecordedObjectValidators.isRecordedObjectNull(recordedObject, callingClassName)) {
            logger.debug("Cannot validate field '" + objectField + "' due to null RecordedObject in '" + callingClassName + "'");
            return false;
        }
        if (!recordedObject.hasField(objectField)) {
            logger.debug("Field '" + objectField + "' does not exist on RecordedObject in '" + callingClassName + "'");
            return false;
        }
        return true;
    }

    public static boolean isRecordedObjectNull(RecordedObject recordedObject, String callingClassName) {
        if (recordedObject != null) {
            return false;
        }
        logger.debug("RecordedObject is null in '" + callingClassName + "'");
        return true;
    }
}

