/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing.samplers;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.tracing.DistributedTraceServiceImpl;
import com.newrelic.agent.tracing.samplers.Sampler;
import com.newrelic.api.agent.NewRelic;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;

public class AdaptiveSampler
implements Sampler {
    private final long reportPeriodMillis;
    private int target;
    private long startTimeMillis;
    private int seen;
    private int seenLast;
    private int sampledCount;
    private int sampledCountLast;
    private boolean firstPeriod;
    private static AdaptiveSampler SAMPLER_SHARED_INSTANCE;

    protected AdaptiveSampler(int target, int reportPeriodSeconds) {
        this.target = target;
        this.reportPeriodMillis = (long)reportPeriodSeconds * 1000L;
        this.startTimeMillis = System.currentTimeMillis();
        this.seen = 0;
        this.seenLast = 0;
        this.sampledCount = 0;
        this.sampledCountLast = 0;
        this.firstPeriod = true;
        NewRelic.getAgent().getLogger().log(Level.INFO, "Started Adaptive Sampler with sampling target " + this.target + " and report period " + reportPeriodSeconds + " seconds.");
    }

    public static synchronized AdaptiveSampler getSharedInstance() {
        if (SAMPLER_SHARED_INSTANCE == null) {
            AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
            SAMPLER_SHARED_INSTANCE = new AdaptiveSampler(config.getAdaptiveSamplingTarget(), config.getAdaptiveSamplingPeriodSeconds());
        }
        return SAMPLER_SHARED_INSTANCE;
    }

    public static synchronized void setSharedTarget(int newTarget) {
        if (SAMPLER_SHARED_INSTANCE != null) {
            NewRelic.getAgent().getLogger().log(Level.INFO, "Updating shared Adaptive Sampler sampling target to " + newTarget);
            AdaptiveSampler.getSharedInstance().setTarget(newTarget);
            ServiceFactory.getStatsService().doStatsWork(StatsWorks.getRecordMetricWork("Supportability/Trace/SamplingTarget/Applied/Value", ((Number)newTarget).floatValue()), "Supportability/Trace/SamplingTarget/Applied/Value");
        }
    }

    @Override
    public synchronized float calculatePriority(Transaction tx) {
        this.resetPeriodIfElapsed();
        return (this.computeSampled() ? 1.0f : 0.0f) + DistributedTraceServiceImpl.nextTruncatedFloat();
    }

    @Override
    public String getType() {
        return "adaptive";
    }

    private void resetPeriodIfElapsed() {
        long now = System.currentTimeMillis();
        if (now - this.startTimeMillis >= this.reportPeriodMillis) {
            NewRelic.getAgent().getLogger().log(Level.FINE, "Resetting sampler period. Seen: " + this.seen + ", Sampled: " + this.sampledCount);
            int elapsedPeriods = (int)((now - this.startTimeMillis) / this.reportPeriodMillis);
            this.startTimeMillis += (long)elapsedPeriods * this.reportPeriodMillis;
            this.seenLast = this.seen;
            this.seen = 0;
            this.sampledCountLast = this.sampledCount;
            this.sampledCount = 0;
            this.firstPeriod = false;
        }
    }

    @VisibleForTesting
    protected boolean computeSampled() {
        boolean sampled;
        if (this.firstPeriod) {
            sampled = this.sampledCount < this.target;
        } else if (this.sampledCount < this.target) {
            sampled = (this.seenLast <= 0 ? 0 : ThreadLocalRandom.current().nextInt(this.seenLast)) < this.target;
        } else if (this.sampledCount >= this.target * 2) {
            sampled = false;
        } else {
            int expTarget = (int)(Math.pow(this.target, (float)this.target / (float)this.sampledCount) - Math.pow(this.target, 0.5));
            sampled = (this.seen <= 0 ? 0 : ThreadLocalRandom.current().nextInt(this.seen)) < expTarget;
        }
        ++this.seen;
        if (sampled) {
            ++this.sampledCount;
        }
        return sampled;
    }

    private synchronized void setTarget(int newTarget) {
        this.target = newTarget;
    }

    @VisibleForTesting
    int getSampledCountLastPeriod() {
        return this.sampledCountLast;
    }

    @VisibleForTesting
    public int getTarget() {
        return this.target;
    }
}

