/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.logging;

import com.newrelic.agent.deps.org.apache.logging.log4j.Marker;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.Filter;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.LogEvent;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.filter.AbstractFilter;
import com.newrelic.agent.logging.Log4jMarkers;
import java.util.logging.Level;

class FineFilter
extends AbstractFilter {
    private static FineFilter instance;
    private volatile Level javaLevel;
    private final Marker markerToMatch = Log4jMarkers.FINE_MARKER;
    private final Marker markerToFail = Log4jMarkers.FINER_MARKER;

    public static FineFilter getFineFilter() {
        if (instance == null) {
            instance = new FineFilter();
        }
        return instance;
    }

    private FineFilter() {
        this.javaLevel = Level.INFO;
    }

    @Override
    public Filter.Result filter(LogEvent event) {
        if (!this.isStarted()) {
            return Filter.Result.NEUTRAL;
        }
        if (Level.FINE.equals(this.javaLevel)) {
            Marker marker = event.getMarker();
            if (marker == null) {
                return Filter.Result.NEUTRAL;
            }
            if (marker.isInstanceOf(this.markerToMatch)) {
                return Filter.Result.ACCEPT;
            }
            if (marker.isInstanceOf(this.markerToFail)) {
                return Filter.Result.DENY;
            }
        }
        return Filter.Result.NEUTRAL;
    }

    public boolean isEnabledFor(Level pLevel) {
        return this.javaLevel.intValue() <= pLevel.intValue();
    }

    public void setLevel(Level level) {
        this.javaLevel = level;
    }

    public Level getLevel() {
        return this.javaLevel;
    }

    @Override
    public void start() {
        if (this.javaLevel != null) {
            super.start();
        }
    }
}

