/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.cloud;

import com.newrelic.api.agent.CloudAccountInfo;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class CloudAccountInfoValidator {
    private static final Pattern AWS_ACCOUNT_ID_PATTERN = Pattern.compile("^\\d+$");
    private static Level awsAccountIdLogLevel = Level.WARNING;

    public static boolean validate(CloudAccountInfo cloudAccountInfo, String value) {
        switch (cloudAccountInfo) {
            case AWS_ACCOUNT_ID: {
                return CloudAccountInfoValidator.validateAwsAccountId(value);
            }
        }
        return false;
    }

    private static boolean validateAwsAccountId(String accountId) {
        boolean valid;
        int AWS_ACCOUNT_ID_LENGTH = 12;
        if (accountId == null) {
            return false;
        }
        boolean bl = valid = accountId.length() == 12 && AWS_ACCOUNT_ID_PATTERN.matcher(accountId).matches();
        if (!valid) {
            NewRelic.getAgent().getLogger().log(awsAccountIdLogLevel, "AWS account ID should be a 12-digit number.");
            awsAccountIdLogLevel = Level.FINEST;
        }
        return valid;
    }

    private CloudAccountInfoValidator() {
    }
}

