/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.cloud;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.cloud.AwsAccountDecoder;
import com.newrelic.api.agent.NewRelic;
import java.util.function.Function;

class AwsAccountDecoderImpl
implements AwsAccountDecoder {
    private final Function<String, String> CACHE = AgentBridge.collectionFactory.createAccessTimeBasedCache(3600L, 4, this::doDecodeAccount);

    @Override
    public String decodeAccount(String accessKey) {
        return this.CACHE.apply(accessKey);
    }

    private String doDecodeAccount(String awsAccessKey) {
        if (awsAccessKey.length() < 16) {
            return null;
        }
        try {
            String accessKeyWithoutPrefix = awsAccessKey.substring(4).toLowerCase();
            long encodedAccount = this.base32Decode(accessKeyWithoutPrefix);
            long mask = 140737488355200L;
            long accountId = (encodedAccount & 0x7FFFFFFFFF80L) >> 7;
            return Long.toString(accountId);
        }
        catch (Exception e) {
            return null;
        }
    }

    private long base32Decode(String src) {
        long base = 0L;
        char[] chars = src.toCharArray();
        for (int i = 0; i < 10; ++i) {
            char c = chars[i];
            base <<= 5;
            if (c >= 'a' && c <= 'z') {
                base += (long)(c - 97);
                continue;
            }
            if (c < '2' || c > '7') continue;
            base += (long)(c - 50 + 26);
        }
        return base >> 2;
    }

    private AwsAccountDecoderImpl() {
    }

    static AwsAccountDecoder newInstance() {
        if (((Boolean)NewRelic.getAgent().getConfig().getValue("cloud.aws.account_decoding.enabled", (Object)true)).booleanValue()) {
            NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/Aws/AccountDecode/enabled");
            return new AwsAccountDecoderImpl();
        }
        NewRelic.getAgent().getMetricAggregator().incrementCounter("Supportability/Aws/AccountDecode/disabled");
        return accessKey -> null;
    }
}

