/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableSet;
import com.newrelic.agent.tracers.DefaultTracer;
import com.newrelic.agent.tracing.DistributedTracePayloadImpl;
import com.newrelic.agent.tracing.Sampled;
import com.newrelic.agent.tracing.SpanProxy;
import com.newrelic.agent.tracing.W3CTraceParentHeader;
import com.newrelic.agent.tracing.W3CTracePayload;
import com.newrelic.agent.tracing.W3CTraceStateHeader;
import com.newrelic.api.agent.ExtendedInboundHeaders;
import com.newrelic.api.agent.HeaderType;
import com.newrelic.api.agent.Headers;
import com.newrelic.api.agent.InboundHeaders;
import com.newrelic.api.agent.NewRelic;
import com.newrelic.api.agent.OutboundHeaders;
import com.newrelic.api.agent.TracedMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class HeadersUtil {
    public static final String NEWRELIC_ID_HEADER = "X-NewRelic-ID";
    public static final String NEWRELIC_ID_MESSAGE_HEADER = "NewRelicID";
    public static final String NEWRELIC_TRANSACTION_HEADER = "X-NewRelic-Transaction";
    public static final String NEWRELIC_TRANSACTION_MESSAGE_HEADER = "NewRelicTransaction";
    public static final String NEWRELIC_APP_DATA_HEADER = "X-NewRelic-App-Data";
    public static final String NEWRELIC_APP_DATA_MESSAGE_HEADER = "NewRelicAppData";
    public static final String NEWRELIC_SYNTHETICS_HEADER = "X-NewRelic-Synthetics";
    public static final String NEWRELIC_SYNTHETICS_MESSAGE_HEADER = "NewRelicSynthetics";
    public static final String NEWRELIC_SYNTHETICS_INFO_HEADER = "X-NewRelic-Synthetics-Info";
    public static final String NEWRELIC_SYNTHETICS_INFO_MESSAGE_HEADER = "NewRelicSyntheticsInfo";
    public static final String NEWRELIC_TRACE_HEADER = "newrelic";
    private static final String NEWRELIC_TRACE_HEADER_UPPER = "NEWRELIC";
    private static final String NEWRELIC_TRACE_HEADER_FIRST_CAPITALIZED = "Newrelic";
    public static final String NEWRELIC_TRACE_MESSAGE_HEADER = "newrelic";
    public static final String NEWRELIC_BAGGAGE_HEADER = "X-NewRelic-Baggage";
    static final String W3C_TRACESTATE_HEADER = "tracestate";
    private static final String W3C_TRACESTATE_HEADER_CAMEL = "TraceState";
    private static final String W3C_TRACESTATE_HEADER_CAPS = "TRACESTATE";
    static final String W3C_TRACEPARENT_HEADER = "traceparent";
    private static final String W3C_TRACEPARENT_HEADER_CAMEL = "TraceParent";
    private static final String W3C_TRACEPARENT_HEADER_CAPS = "TRACEPARENT";
    public static final int SYNTHETICS_MIN_VERSION = 1;
    public static final int SYNTHETICS_MAX_VERSION = 1;
    public static final int SYNTHETICS_VERSION_NONE = -1;
    public static final Set<String> NEWRELIC_HEADERS = ImmutableSet.of("X-NewRelic-ID", "NewRelicID", "X-NewRelic-Transaction", "NewRelicTransaction", "X-NewRelic-App-Data", "NewRelicAppData", new String[]{"X-NewRelic-Synthetics", "NewRelicSynthetics", "X-NewRelic-Synthetics-Info", "NewRelicSyntheticsInfo"});

    public static String getIdHeader(InboundHeaders headers) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_ID_HEADER, NEWRELIC_ID_MESSAGE_HEADER);
        return key == null ? null : headers.getHeader(key);
    }

    public static String getTransactionHeader(InboundHeaders headers) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_TRANSACTION_HEADER, NEWRELIC_TRANSACTION_MESSAGE_HEADER);
        return key == null ? null : headers.getHeader(key);
    }

    public static String getAppDataHeader(InboundHeaders headers) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_APP_DATA_HEADER, NEWRELIC_APP_DATA_MESSAGE_HEADER);
        return key == null ? null : headers.getHeader(key);
    }

    public static String getSyntheticsHeader(InboundHeaders headers) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_SYNTHETICS_HEADER, NEWRELIC_SYNTHETICS_MESSAGE_HEADER);
        return key == null ? null : headers.getHeader(key);
    }

    public static String getSyntheticsInfoHeader(InboundHeaders headers) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_SYNTHETICS_INFO_HEADER, NEWRELIC_SYNTHETICS_INFO_MESSAGE_HEADER);
        return key == null ? null : headers.getHeader(key);
    }

    public static String getNewRelicTraceHeader(InboundHeaders headers) {
        String value;
        String value2;
        String value3;
        String lowercase = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), "newrelic", "newrelic");
        if (lowercase != null && (value3 = headers.getHeader(lowercase)) != null) {
            return value3;
        }
        String uppercase = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_TRACE_HEADER_UPPER, "newrelic");
        if (uppercase != null && (value2 = headers.getHeader(uppercase)) != null) {
            return value2;
        }
        String firstUppercase = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_TRACE_HEADER_FIRST_CAPITALIZED, "newrelic");
        if (firstUppercase != null && (value = headers.getHeader(firstUppercase)) != null) {
            return value;
        }
        return null;
    }

    static List<String> getTraceParentHeader(InboundHeaders inboundHeaders) {
        return HeadersUtil.getHeadersTryingDifferentCases(inboundHeaders, W3C_TRACEPARENT_HEADER, W3C_TRACEPARENT_HEADER_CAMEL, W3C_TRACEPARENT_HEADER_CAPS);
    }

    static List<String> getTraceStateHeader(InboundHeaders inboundHeaders) {
        return HeadersUtil.getHeadersTryingDifferentCases(inboundHeaders, W3C_TRACESTATE_HEADER, W3C_TRACESTATE_HEADER_CAMEL, W3C_TRACESTATE_HEADER_CAPS);
    }

    private static List<String> getHeadersTryingDifferentCases(InboundHeaders inboundHeaders, String ... caseVariants) {
        for (String variant : caseVariants) {
            List<String> headers = HeadersUtil.getHeaders(inboundHeaders, variant);
            if (headers == null) continue;
            return headers;
        }
        return null;
    }

    private static List<String> getHeaders(InboundHeaders inboundHeaders, String key) {
        if (inboundHeaders instanceof ExtendedInboundHeaders) {
            return ((ExtendedInboundHeaders)inboundHeaders).getHeaders(key);
        }
        if (inboundHeaders instanceof Headers) {
            return new ArrayList<String>(((Headers)inboundHeaders).getHeaders(key));
        }
        String header = inboundHeaders.getHeader(key);
        return header != null ? Collections.singletonList(header) : null;
    }

    public static void setIdHeader(OutboundHeaders headers, String crossProcessId) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_ID_HEADER, NEWRELIC_ID_MESSAGE_HEADER);
        headers.setHeader(key, crossProcessId);
    }

    public static void setTransactionHeader(OutboundHeaders headers, String value) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_TRANSACTION_HEADER, NEWRELIC_TRANSACTION_MESSAGE_HEADER);
        headers.setHeader(key, value);
    }

    public static void setAppDataHeader(OutboundHeaders headers, String value) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_APP_DATA_HEADER, NEWRELIC_APP_DATA_MESSAGE_HEADER);
        headers.setHeader(key, value);
    }

    public static void setSyntheticsHeader(OutboundHeaders headers, String value) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_SYNTHETICS_HEADER, NEWRELIC_SYNTHETICS_MESSAGE_HEADER);
        headers.setHeader(key, value);
    }

    public static void setSyntheticsInfoHeader(OutboundHeaders headers, String value) {
        String key = HeadersUtil.getTypedHeaderKey(headers.getHeaderType(), NEWRELIC_SYNTHETICS_INFO_HEADER, NEWRELIC_SYNTHETICS_INFO_MESSAGE_HEADER);
        headers.setHeader(key, value);
    }

    public static void setNewRelicTraceHeader(OutboundHeaders headers, String value) {
        headers.setHeader("newrelic", value);
    }

    public static void setTraceStateHeader(OutboundHeaders headers, String value) {
        headers.setHeader(W3C_TRACESTATE_HEADER, value);
    }

    public static void setTraceParentHeader(OutboundHeaders headers, String value) {
        headers.setHeader(W3C_TRACEPARENT_HEADER, value);
    }

    public static void parseAndAcceptDistributedTraceHeaders(Transaction tx, InboundHeaders inboundHeaders) {
        List<String> traceParent = HeadersUtil.getTraceParentHeader(inboundHeaders);
        if (traceParent != null && !traceParent.isEmpty()) {
            List<String> traceState = HeadersUtil.getTraceStateHeader(inboundHeaders);
            W3CTracePayload w3CTracePayload = W3CTracePayload.parseHeaders(tx, traceParent, traceState);
            if (w3CTracePayload != null) {
                if (w3CTracePayload.getPayload() != null) {
                    tx.acceptDistributedTracePayload(w3CTracePayload.getPayload());
                }
                if (w3CTracePayload.getTraceParent() != null) {
                    tx.getSpanProxy().setInitiatingW3CTraceParent(w3CTracePayload.getTraceParent());
                    tx.assignPriorityFromRemoteParent(w3CTracePayload.getTraceParent().sampled());
                }
                if (w3CTracePayload.getTraceState() != null) {
                    tx.getSpanProxy().setInitiatingW3CTraceState(w3CTracePayload.getTraceState());
                }
            }
        } else {
            String tracePayload = HeadersUtil.getNewRelicTraceHeader(inboundHeaders);
            if (tracePayload != null) {
                boolean samplingDecisionExists;
                tx.acceptDistributedTracePayload(tracePayload);
                DistributedTracePayloadImpl newRelicPayload = tx.getSpanProxy().getInboundDistributedTracePayload();
                boolean bl = samplingDecisionExists = newRelicPayload.sampled != Sampled.UNKNOWN;
                if (samplingDecisionExists) {
                    tx.assignPriorityFromRemoteParent(newRelicPayload.sampled.booleanValue());
                }
            }
        }
    }

    public static boolean createAndSetDistributedTraceHeaders(Transaction tx, TracedMethod tracedMethod, OutboundHeaders headers) {
        String spanId = HeadersUtil.getSpanId(tx, tracedMethod);
        DistributedTracePayloadImpl payload = tx.createDistributedTracePayload(spanId);
        if (payload == null) {
            return false;
        }
        Agent.LOG.log(Level.FINER, "Sending distributed trace header in transaction {0}", tx);
        DistributedTracingConfig distributedTracingConfig = tx.getAgentConfig().getDistributedTracingConfig();
        boolean includeNewRelicHeader = distributedTracingConfig.isIncludeNewRelicHeader();
        if (includeNewRelicHeader) {
            HeadersUtil.setNewRelicTraceHeader(headers, payload.httpSafe());
        }
        try {
            SpanProxy spanProxy = tx.getSpanProxy();
            HeadersUtil.setTraceParentHeader(headers, W3CTraceParentHeader.create(spanProxy, payload.traceId, payload.guid, payload.sampled.booleanValue()));
            W3CTraceStateHeader traceStateHeader = new W3CTraceStateHeader(HeadersUtil.spanEventsEnabled(tx), HeadersUtil.transactionEventsEnabled(tx));
            String traceStateHeaderValue = traceStateHeader.create(spanProxy);
            HeadersUtil.setTraceStateHeader(headers, traceStateHeaderValue);
            tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/Create/Success");
        }
        catch (Exception e) {
            tx.getMetricAggregator().incrementCounter("Supportability/TraceContext/Create/Exception");
        }
        return true;
    }

    private static String getSpanId(Transaction tx, TracedMethod tracedMethod) {
        if (tracedMethod instanceof DefaultTracer && HeadersUtil.spanEventsEnabled(tx)) {
            DefaultTracer tracer = (DefaultTracer)tracedMethod;
            return tracer.getGuid();
        }
        return null;
    }

    private static boolean spanEventsEnabled(Transaction tx) {
        return tx.getAgentConfig().getSpanEventsConfig().isEnabled();
    }

    private static boolean transactionEventsEnabled(Transaction tx) {
        return tx.getAgentConfig().getTransactionEventsConfig().isEnabled();
    }

    private static String getTypedHeaderKey(HeaderType type, String httpHeader, String messageHeader) {
        if (type == null) {
            NewRelic.getAgent().getLogger().log(Level.FINE, "null is not a valid header type");
            return null;
        }
        switch (type) {
            case MESSAGE: {
                return messageHeader;
            }
            case HTTP: {
                return httpHeader;
            }
        }
        NewRelic.getAgent().getLogger().log(Level.FINE, "{0} is not a valid header type", (Object)type);
        return null;
    }
}

