/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.deps.com.google.common.base.Strings;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.tracing.SpanProxy;
import com.newrelic.agent.tracing.W3CTraceParent;
import java.util.Locale;

public class W3CTraceParentHeader {
    static final String W3C_VERSION = "00";
    static final String W3C_TRACE_PARENT_DELIMITER = "-";

    public static String create(SpanProxy proxy, String traceId, String guid, boolean sampled) {
        W3CTraceParent existingW3cTraceParent = proxy.getInitiatingW3CTraceParent();
        if (existingW3cTraceParent == null) {
            return W3CTraceParentHeader.createNewHeader(proxy, traceId, guid, sampled);
        }
        return W3CTraceParentHeader.forwardHeader(existingW3cTraceParent, guid, sampled);
    }

    private static String createNewHeader(SpanProxy proxy, String traceId, String guid, boolean sampled) {
        String parentId = guid == null ? TransactionGuidFactory.generate16CharGuid() : guid;
        proxy.setInitiatingW3CTraceParent(new W3CTraceParent(W3C_VERSION, traceId, null, sampled ? 1 : 0));
        String w3cTraceId = W3CTraceParentHeader.maybePad(W3CTraceParentHeader.maybeLower(traceId));
        return W3CTraceParentHeader.createHeader(sampled, parentId, w3cTraceId);
    }

    private static String createHeader(boolean sampled, String parentId, String w3cTraceId) {
        return "00-" + w3cTraceId + W3C_TRACE_PARENT_DELIMITER + parentId + W3C_TRACE_PARENT_DELIMITER + W3CTraceParentHeader.sampledToFlags(sampled);
    }

    private static String maybeLower(String traceId) {
        return traceId.toLowerCase(Locale.ROOT);
    }

    private static String maybePad(String txnId) {
        return Strings.padStart(txnId, 32, '0');
    }

    private static String forwardHeader(W3CTraceParent existingW3cTraceParent, String guid, boolean sampled) {
        String parentId = guid == null ? TransactionGuidFactory.generate16CharGuid() : guid;
        return W3CTraceParentHeader.createHeader(sampled, parentId, existingW3cTraceParent.getTraceId());
    }

    private static String sampledToFlags(boolean sampled) {
        return sampled ? "01" : W3C_VERSION;
    }
}

