/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.TransactionData;
import com.newrelic.agent.attributes.AttributeValidator;
import com.newrelic.agent.attributes.AttributesUtils;
import com.newrelic.agent.config.DistributedTracingConfig;
import com.newrelic.agent.environment.AgentIdentity;
import com.newrelic.agent.environment.Environment;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.errors.DeadlockTraceError;
import com.newrelic.agent.errors.ErrorDataImpl;
import com.newrelic.agent.errors.ErrorGroupCallbackHolder;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.json.AttributeFilters;
import com.newrelic.agent.model.ErrorEvent;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.api.agent.ErrorData;
import com.newrelic.api.agent.NewRelic;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class ErrorEventFactory {
    private static final String ERROR_GROUP_NAME_ATTR = "error.group.name";

    public static ErrorEvent create(String appName, TracedError tracedError, float priority) {
        return new ErrorEvent(appName, tracedError.getTimestampInMillis(), priority, new HashMap<String, Object>(tracedError.getErrorAtts()), tracedError.getExceptionClass(), ErrorEventFactory.truncateIfNecessary(tracedError.getMessage()), ErrorEventFactory.isErrorExpected(tracedError), "Unknown", Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, null, null, null, null, null, null, null, null, ErrorEventFactory.getPortUsingServiceManagerIfPossible(), null, null, Collections.emptyMap(), ErrorEventFactory.buildAgentAttributes(null, null, tracedError), AttributeFilters.ERROR_EVENTS_ATTRIBUTE_FILTER);
    }

    public static ErrorEvent create(String appName, TracedError tracedError, TransactionData transactionData, TransactionStats transactionStats) {
        long timestamp = tracedError.getTimestampInMillis();
        Map<String, Object> userAttributes = ErrorEventFactory.buildUserAttributes(appName, transactionData);
        String errorMessage = ErrorEventFactory.truncateIfNecessary(tracedError.getMessage());
        String transactionName = transactionData.getPriorityTransactionName().getName();
        return new ErrorEvent(appName, timestamp, transactionData.getPriority(), userAttributes, tracedError.getExceptionClass(), errorMessage, ErrorEventFactory.isErrorExpected(tracedError), transactionName, (float)transactionData.getDurationInMillis() / 1000.0f, ErrorEventFactory.getMetricTotal(transactionStats, "WebFrontend/QueueTime"), ErrorEventFactory.getMetricTotal(transactionStats, "External/all"), ErrorEventFactory.getMetricTotal(transactionStats, "Datastore/all"), ErrorEventFactory.getMetricTotal(transactionStats, "GC/cumulative"), ErrorEventFactory.getMetricCount(transactionStats, "Datastore/all"), ErrorEventFactory.getMetricCount(transactionStats, "External/all"), transactionData.getGuid(), transactionData.getReferrerGuid(), transactionData.getSyntheticsResourceId(), transactionData.getSyntheticsMonitorId(), transactionData.getSyntheticsJobId(), transactionData.getSyntheticsType(), transactionData.getSyntheticsInitiator(), transactionData.getSyntheticsAttributes(), ErrorEventFactory.getPortUsingServiceManagerIfPossible(), transactionData.getTimeoutCause() == null ? null : transactionData.getTimeoutCause().cause, ErrorEventFactory.getTripId(transactionData), ErrorEventFactory.getDistributedTraceIntrinsics(transactionData), ErrorEventFactory.buildAgentAttributes(appName, transactionData, tracedError), AttributeFilters.ERROR_EVENTS_ATTRIBUTE_FILTER);
    }

    private static float getMetricTotal(TransactionStats transactionStats, String metricName) {
        if (ErrorEventFactory.metricExists(transactionStats, metricName)) {
            return ErrorEventFactory.getMetric(transactionStats, metricName).getTotal();
        }
        return Float.NEGATIVE_INFINITY;
    }

    private static int getMetricCount(TransactionStats transactionStats, String metricName) {
        if (ErrorEventFactory.metricExists(transactionStats, metricName)) {
            return ErrorEventFactory.getMetric(transactionStats, metricName).getCallCount();
        }
        return 0;
    }

    private static boolean metricExists(TransactionStats transactionStats, String metricName) {
        return transactionStats.getUnscopedStats().getStatsMap().containsKey(metricName);
    }

    private static ResponseTimeStats getMetric(TransactionStats transactionStats, String metricName) {
        return transactionStats.getUnscopedStats().getOrCreateResponseTimeStats(metricName);
    }

    private static String truncateIfNecessary(String value) {
        if (value.getBytes(StandardCharsets.UTF_8).length > 1024) {
            return AttributeValidator.truncateString(value, 1024);
        }
        return value;
    }

    private static String getTripId(TransactionData transactionData) {
        return ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig().isEnabled() ? transactionData.getTripId() : null;
    }

    private static boolean isErrorExpected(TracedError tracedError) {
        return !tracedError.incrementsErrorMetric() && !(tracedError instanceof DeadlockTraceError);
    }

    private static int getPortUsingServiceManagerIfPossible() {
        Integer serverPort;
        AgentIdentity agentIdentity;
        Environment environment;
        EnvironmentService environmentService;
        ServiceManager serviceManager = ServiceFactory.getServiceManager();
        if (serviceManager != null && (environmentService = serviceManager.getEnvironmentService()) != null && (environment = environmentService.getEnvironment()) != null && (agentIdentity = environment.getAgentIdentity()) != null && (serverPort = agentIdentity.getServerPort()) != null) {
            return serverPort;
        }
        return Integer.MIN_VALUE;
    }

    private static Map<String, Object> getDistributedTraceIntrinsics(TransactionData transactionData) {
        DistributedTracingConfig distributedTracingConfig = ServiceFactory.getConfigService().getDefaultAgentConfig().getDistributedTracingConfig();
        if (!distributedTracingConfig.isEnabled()) {
            return null;
        }
        DistributedTraceService distributedTraceService = ServiceFactory.getDistributedTraceService();
        return distributedTraceService.getIntrinsics(transactionData.getInboundDistributedTracePayload(), transactionData.getGuid(), transactionData.getTraceId(), transactionData.getTransportType(), transactionData.getTransportDurationInMillis(), transactionData.getLargestTransportDurationInMillis(), transactionData.getParentId(), transactionData.getParentSpanId(), transactionData.getPriority());
    }

    private static Map<String, Object> buildAgentAttributes(String appName, TransactionData transactionData, TracedError tracedError) {
        String groupId;
        String spanId;
        if (!ServiceFactory.getAttributesService().isAttributesEnabledForErrorEvents(appName)) {
            return null;
        }
        HashMap<String, Object> agentAttrs = new HashMap<String, Object>();
        if (transactionData != null) {
            agentAttrs.putAll(transactionData.getAgentAttributes());
            agentAttrs.putAll(AttributesUtils.appendAttributePrefixes(transactionData.getPrefixedAttributes()));
        }
        if (tracedError != null && tracedError.getAgentAtts() != null) {
            agentAttrs.putAll(tracedError.getAgentAtts());
        }
        if (transactionData != null && transactionData.getThrowable() != null && (spanId = transactionData.getThrowable().spanId) != null) {
            agentAttrs.put("spanId", spanId);
        }
        if ((groupId = ErrorEventFactory.invokeErrorGroupCallback(transactionData, tracedError)) != null && !"".equals(groupId)) {
            agentAttrs.put(ERROR_GROUP_NAME_ATTR, groupId);
        }
        return agentAttrs;
    }

    private static Map<String, Object> buildUserAttributes(String appName, TransactionData transactionData) {
        HashMap<String, Object> userAttributes = new HashMap<String, Object>();
        if (ServiceFactory.getAttributesService().isAttributesEnabledForErrorEvents(appName)) {
            userAttributes.putAll(transactionData.getUserAttributes());
            userAttributes.putAll(transactionData.getErrorAttributes());
        }
        return userAttributes;
    }

    private static String invokeErrorGroupCallback(TransactionData transactionData, TracedError tracedError) {
        String groupId = null;
        try {
            if (ErrorGroupCallbackHolder.getErrorGroupCallback() != null) {
                long start = System.currentTimeMillis();
                groupId = ErrorGroupCallbackHolder.getErrorGroupCallback().generateGroupingString((ErrorData)new ErrorDataImpl(transactionData, tracedError));
                long duration = System.currentTimeMillis() - start;
                NewRelic.getAgent().getMetricAggregator().recordResponseTimeMetric("Supportability/ErrorGrouping/Callback/ExecutionTime", duration);
                NewRelic.getAgent().getLogger().log(Level.FINEST, "Customer errorGroupCallback generated groupId of [{0}] in {1}ms", (Object)groupId, (Object)duration);
            }
        }
        catch (Exception e) {
            if (NewRelic.getAgent().getLogger().isLoggable(Level.FINEST)) {
                NewRelic.getAgent().getLogger().log(Level.FINEST, (Throwable)e, "Customer errorGroupCallback threw an exception.");
            }
            NewRelic.getAgent().getLogger().log(Level.WARNING, "Customer errorGroupCallback implementation threw an exception: {0}", (Object)e.getMessage());
        }
        return groupId;
    }
}

