/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.samplers;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.samplers.MetricSampler;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.AccessControlException;
import java.text.MessageFormat;

public class ThreadSampler
implements MetricSampler {
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private final boolean isDeadlockDetectorEnabled;

    public ThreadSampler() {
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.isDeadlockDetectorEnabled = (Boolean)config.getValue("deadlock_detector.enabled", true);
    }

    @Override
    public void sample(StatsEngine statsEngine) {
        int threadCount = this.threadMXBean.getThreadCount();
        statsEngine.getStats("Threads/all").setCallCount(threadCount);
        if (this.isDeadlockDetectorEnabled) {
            long[] deadlockedThreadIds;
            try {
                deadlockedThreadIds = this.threadMXBean.findMonitorDeadlockedThreads();
            }
            catch (AccessControlException e) {
                Agent.LOG.warning(MessageFormat.format("An error occurred calling ThreadMXBean.findMonitorDeadlockedThreads: {0}", e));
                deadlockedThreadIds = new long[]{};
            }
            int deadlockCount = deadlockedThreadIds == null ? 0 : deadlockedThreadIds.length;
            statsEngine.getStats("Threads/Deadlocks/all").setCallCount(deadlockCount);
        }
    }
}

