/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.verification;

import com.newrelic.weave.utils.ClassCache;
import com.newrelic.weave.utils.ClassLoaderFinder;
import com.newrelic.weave.verification.VerificationClassLoader;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.weavepackage.CachedWeavePackage;
import com.newrelic.weave.weavepackage.PackageValidationResult;
import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public class WeavePackageVerifier {
    private final PrintStream out;
    private final String instrumentationJar;
    private final List<String> userJars;

    public static void main(String[] args2) {
        block5: {
            String instrumentationJar = args2[0];
            boolean expectedVerificationResult = Boolean.valueOf(args2[1]);
            String taskName = args2[2];
            boolean printSuccess = Boolean.valueOf(args2[3]);
            ArrayList<String> userJars = new ArrayList();
            if (args2.length > 4) {
                userJars = Arrays.asList(args2).subList(4, args2.length);
            }
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                PrintStream output = new PrintStream(outputStream);
                boolean passed = WeavePackageVerifier.verify(output, instrumentationJar, userJars);
                output.println(taskName);
                if (passed == expectedVerificationResult) {
                    if (printSuccess) {
                        output.println("SUCCEEDED");
                        System.out.println(new String(outputStream.toByteArray()));
                    }
                    break block5;
                }
                output.println("FAILED");
                output.println("-- Expected verification result:" + expectedVerificationResult);
                output.println("-- Actual verification result:" + passed);
                System.err.println(new String(outputStream.toByteArray()));
                throw new RuntimeException("FAILED");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static boolean verify(PrintStream out, String instrumentationJar, List<String> userJars) throws Exception {
        return new WeavePackageVerifier(out, instrumentationJar, userJars).verify();
    }

    private WeavePackageVerifier(PrintStream out, String instrumentationJar, List<String> userJars) {
        this.out = out;
        this.instrumentationJar = instrumentationJar;
        this.userJars = userJars;
    }

    private boolean verify() throws Exception {
        ClassLoader loader;
        ClassCache cache;
        WeavePackage weavePackage = this.getWeavePackage(this.instrumentationJar);
        PackageValidationResult result = weavePackage.validate(cache = new ClassCache(new ClassLoaderFinder(loader = this.createClassloaderForVerification(this.userJars))));
        if (!result.succeeded()) {
            for (WeaveViolation violation : result.getViolations()) {
                this.out.println(violation.toString());
            }
        }
        return result.succeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WeavePackage getWeavePackage(String instrumentationJar) throws Exception {
        URL instrumentationJarUrl = new File(instrumentationJar).toURI().toURL();
        ZipInputStream jarStream = null;
        try {
            WeavePackageConfig config = WeavePackageConfig.builder().url(instrumentationJarUrl).build();
            jarStream = new JarInputStream(instrumentationJarUrl.openStream());
            WeavePackage weavePackage = CachedWeavePackage.createWeavePackage((JarInputStream)jarStream, config);
            return weavePackage;
        }
        finally {
            if (null != jarStream) {
                jarStream.close();
            }
        }
    }

    private ClassLoader createClassloaderForVerification(List<String> jars) throws MalformedURLException {
        HashSet<URL> urls = new HashSet<URL>();
        this.out.println("Creating user classloader with custom classpath:");
        for (String s2 : jars) {
            File jarFile = new File(s2);
            if (!jarFile.exists()) {
                this.out.println(String.format("\tWARNING: Given jar does not exist: %s", s2));
            }
            urls.add(jarFile.toURI().toURL());
            this.out.println(String.format("\t%s", s2));
        }
        return new VerificationClassLoader(urls.toArray(new URL[urls.size()]));
    }
}

