/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.TransactionActivity;
import com.newrelic.agent.deps.com.google.common.collect.ImmutableMap;
import com.newrelic.agent.profile.v2.BaseTree;
import com.newrelic.agent.profile.v2.IProfile;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import com.newrelic.agent.profile.v2.TraceProfileSegment;
import com.newrelic.agent.tracers.Tracer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class TransactionActivityTree
extends BaseTree<TraceProfileSegment> {
    private final AtomicLong cpuTimeInNanos = new AtomicLong();

    public TransactionActivityTree(IProfile profile) {
        super(profile);
    }

    @Override
    protected Map<String, Object> getExtraData() {
        long cpuTime = this.cpuTimeInNanos.get();
        if (cpuTime > 0L) {
            return ImmutableMap.of("cpu_time", TimeUnit.NANOSECONDS.toMillis(cpuTime));
        }
        return ImmutableMap.of();
    }

    public void add(TransactionActivity activity, Map<Tracer, Collection<Tracer>> tracerTree) {
        this.add(null, activity.getRootTracer(), tracerTree);
        this.cpuTimeInNanos.addAndGet(activity.getTotalCpuTime());
    }

    private void add(TraceProfileSegment parent, Tracer tracer, Map<Tracer, Collection<Tracer>> children) {
        ProfiledMethod profiledMethod = this.profile.getProfiledMethodFactory().getProfiledMethod(tracer);
        TraceProfileSegment thisSegment = this.add(profiledMethod, parent, true);
        thisSegment.update(tracer);
        Collection<Tracer> kids = children.get(tracer);
        if (null != kids) {
            for (Tracer kid : kids) {
                this.add(thisSegment, kid, children);
            }
        }
    }

    @Override
    protected TraceProfileSegment createProfiledMethod(ProfiledMethod method) {
        return TraceProfileSegment.newProfileSegment(method);
    }
}

