/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.instrumentation.context;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.instrumentation.context.ClassMatchVisitorFactory;
import com.newrelic.agent.instrumentation.context.InstrumentationContextClassMatcherHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class ClassesMatcher {
    public static final int MAX_NUMBER_OF_THREADS = 8;

    public static Set<Class<?>> getMatchingClasses(final Collection<ClassMatchVisitorFactory> matchers, final InstrumentationContextClassMatcherHelper matchHelper, Class<?> ... classes) {
        final Set<Class<?>> matchingClasses = Sets.newConcurrentHashSet();
        if (classes == null || classes.length == 0) {
            return matchingClasses;
        }
        double partitions = Math.min(classes.length, 8);
        int estimatedPerPartition = (int)Math.ceil((double)classes.length / partitions);
        List<List<Class<?>>> partitionsClasses = Lists.partition(Arrays.asList(classes), estimatedPerPartition);
        final CountDownLatch countDownLatch = new CountDownLatch(partitionsClasses.size());
        for (final List<Class<?>> partitionClasses : partitionsClasses) {
            Runnable matchingRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Class clazz : partitionClasses) {
                            if (!matchHelper.isMatch(matchers, clazz)) continue;
                            matchingClasses.add(clazz);
                        }
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            };
            new Thread(matchingRunnable).start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            Agent.LOG.log(Level.INFO, "Failed to wait for matching classes");
            Agent.LOG.log(Level.FINER, e, "Interrupted during class matching");
        }
        return matchingClasses;
    }
}

