/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.com.google.common.collect;

import com.newrelic.agent.deps.com.google.common.annotations.GwtCompatible;
import com.newrelic.agent.deps.com.google.common.annotations.GwtIncompatible;
import com.newrelic.agent.deps.com.google.common.collect.AbstractMapBasedMultiset;
import com.newrelic.agent.deps.com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.newrelic.agent.deps.com.google.common.collect.Iterables;
import com.newrelic.agent.deps.com.google.common.collect.Multisets;
import com.newrelic.agent.deps.com.google.common.collect.ObjectCountHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> HashMultiset<E> create() {
        return HashMultiset.create(3);
    }

    public static <E> HashMultiset<E> create(int distinctElements) {
        return new HashMultiset<E>(distinctElements);
    }

    public static <E> HashMultiset<E> create(Iterable<? extends E> elements) {
        HashMultiset<E> multiset = HashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    HashMultiset(int distinctElements) {
        super(distinctElements);
    }

    @Override
    ObjectCountHashMap<E> newBackingMap(int distinctElements) {
        return new ObjectCountHashMap(distinctElements);
    }
}

