/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.deps.org.json.simple.parser.ParseException;
import com.newrelic.agent.utilization.AwsFargateMetadataFetcher;
import com.newrelic.agent.utilization.CGroup;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerData {
    private static final String FILE_WITH_CONTAINER_ID_V1 = "/proc/self/cgroup";
    private static final String FILE_WITH_CONTAINER_ID_V2 = "/proc/self/mountinfo";
    private static final String CPU = "cpu";
    private static final String AWS_ECS_METADATA_UNVERSIONED_ENV_VAR = "ECS_CONTAINER_METADATA_URI";
    private static final String AWS_ECS_METADATA_V4_ENV_VAR = "ECS_CONTAINER_METADATA_URI_V4";
    private static final String FARGATE_DOCKER_ID_KEY = "DockerId";
    private static final Pattern VALID_CONTAINER_ID = Pattern.compile("^[0-9a-f]{64}$");
    private static final Pattern DOCKER_CONTAINER_STRING_V1 = Pattern.compile("^.*[^0-9a-f]+([0-9a-f]{64,}).*");
    private static final Pattern DOCKER_CONTAINER_STRING_V2 = Pattern.compile(".*/docker/containers/([0-9a-f]{64,}).*");

    public String getDockerContainerIdForEcsFargate(boolean isLinux) {
        if (isLinux) {
            String fargateUrl = null;
            try {
                fargateUrl = System.getenv(AWS_ECS_METADATA_V4_ENV_VAR);
                if (fargateUrl != null) {
                    Agent.LOG.log(Level.INFO, "Attempting to fetch ECS Fargate container id from URL (v4): {0}", fargateUrl);
                    String result = this.retrieveDockerIdFromFargateMetadata(new AwsFargateMetadataFetcher(fargateUrl));
                    if (result != null) {
                        return result;
                    }
                }
                if ((fargateUrl = System.getenv(AWS_ECS_METADATA_UNVERSIONED_ENV_VAR)) != null) {
                    Agent.LOG.log(Level.INFO, "Attempting to fetch ECS Fargate container id from URL (unversioned): {0}", fargateUrl);
                    return this.retrieveDockerIdFromFargateMetadata(new AwsFargateMetadataFetcher(fargateUrl));
                }
            }
            catch (MalformedURLException e) {
                Agent.LOG.log(Level.FINEST, "Invalid AWS Fargate metadata URL: {0}", fargateUrl);
            }
        }
        return null;
    }

    public String getDockerContainerIdFromCGroups(boolean isLinux) {
        if (isLinux) {
            File containerIdFileV2 = new File(FILE_WITH_CONTAINER_ID_V2);
            String result = this.getDockerIdFromFile(containerIdFileV2, CGroup.V2);
            if (result != null) {
                return result;
            }
            File containerIdFileV1 = new File(FILE_WITH_CONTAINER_ID_V1);
            result = this.getDockerIdFromFile(containerIdFileV1, CGroup.V1);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    String getDockerIdFromFile(File mountInfoFile, CGroup cgroup) {
        if (mountInfoFile.exists() && mountInfoFile.canRead()) {
            try {
                return this.readFile(new FileReader(mountInfoFile), cgroup);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readFile(Reader reader, CGroup cgroup) {
        try (BufferedReader bReader = new BufferedReader(reader);){
            String line;
            StringBuilder resultGoesHere = new StringBuilder();
            do {
                if ((line = bReader.readLine()) == null) return null;
            } while (!this.checkLineAndGetResult(line, resultGoesHere, cgroup));
            String value = resultGoesHere.toString().trim();
            if (this.isInvalidDockerValue(value)) {
                Agent.LOG.log(Level.WARNING, MessageFormat.format("Failed to validate Docker value {0}", value));
                String string = null;
                return string;
            }
            String string = value;
            return string;
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINEST, e, "Exception occurred when reading docker file.");
        }
        return null;
    }

    boolean checkLineAndGetResult(String line, StringBuilder resultGoesHere, CGroup cgroup) {
        if (cgroup == CGroup.V1) {
            return this.checkLineAndGetResultV1(line, resultGoesHere);
        }
        if (cgroup == CGroup.V2) {
            return this.checkLineAndGetResultV2(line, resultGoesHere);
        }
        return false;
    }

    private boolean checkLineAndGetResultV1(String line, StringBuilder resultGoesHere) {
        String[] parts = line.split(":");
        if (parts.length == 3 && this.validCpuLine(parts[1])) {
            String mayContainId = parts[2];
            if (this.checkAndGetMatch(DOCKER_CONTAINER_STRING_V1, resultGoesHere, mayContainId)) {
                return true;
            }
            if (!mayContainId.equals("/")) {
                Agent.LOG.log(Level.FINE, "Docker Data: Ignoring unrecognized cgroup ID format: {0}", mayContainId);
            }
        }
        return false;
    }

    private boolean checkLineAndGetResultV2(String line, StringBuilder resultGoesHere) {
        String mayContainId;
        String[] parts = line.split(" ");
        return parts.length >= 4 && this.checkAndGetMatch(DOCKER_CONTAINER_STRING_V2, resultGoesHere, mayContainId = parts[3]);
    }

    boolean isInvalidDockerValue(String value) {
        return value == null || !VALID_CONTAINER_ID.matcher(value).matches();
    }

    private boolean validCpuLine(String segment) {
        if (segment != null) {
            String[] parts;
            for (String current : parts = segment.split(",")) {
                if (!current.equals(CPU)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkAndGetMatch(Pattern p, StringBuilder result, String segment) {
        Matcher m4 = p.matcher(segment);
        if (m4.matches() && m4.groupCount() == 1) {
            result.append(m4.group(1));
            return true;
        }
        return false;
    }

    @VisibleForTesting
    String retrieveDockerIdFromFargateMetadata(AwsFargateMetadataFetcher awsFargateMetadataFetcher) {
        String dockerId = null;
        StringBuilder jsonBlob = new StringBuilder();
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(awsFargateMetadataFetcher.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    jsonBlob.append(line);
                }
            }
            JSONObject jsonObject = (JSONObject)new JSONParser().parse(jsonBlob.toString());
            dockerId = (String)jsonObject.get(FARGATE_DOCKER_ID_KEY);
            Agent.LOG.log(Level.INFO, "ECS Fargate container id: {0} ", dockerId);
        }
        catch (IOException e) {
            Agent.LOG.log(Level.WARNING, "Error opening input stream retrieving AWS Fargate metadata");
        }
        catch (ParseException e) {
            Agent.LOG.log(Level.WARNING, "Error parsing JSON blob for AWS Fargate metadata");
        }
        return dockerId;
    }
}

