/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.util;

import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.util.StackTraces;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class JSONException
extends Exception
implements JSONStreamAware {
    private static final long serialVersionUID = 3132223563667774992L;

    public JSONException(String message, Throwable cause) {
        super(message, cause);
    }

    public JSONException(String message) {
        super(message);
    }

    public JSONException(Throwable cause) {
        super(cause);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(new HashMap<String, Map>(){
            {
                HashMap<String, Object> vals = new HashMap<String, Object>();
                vals.put("message", JSONException.this.getMessage());
                Throwable cause = JSONException.this.getCause();
                if (cause != null) {
                    vals.put("type", cause.getClass().getName());
                }
                vals.put("backtrace", StackTraces.stackTracesToStrings(JSONException.this.getStackTrace()));
                this.put("exception", vals);
            }
        }, out);
    }
}

