/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service.analytics;

import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.SpanEventsConfig;
import com.newrelic.agent.deps.com.google.common.collect.ComparisonChain;
import com.newrelic.agent.interfaces.ReservoirManager;
import com.newrelic.agent.interfaces.SamplingPriorityQueue;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.agent.service.analytics.AdaptiveSampling;
import com.newrelic.agent.service.analytics.DistributedSamplingPriorityQueue;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.api.agent.Logger;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class CollectorSpanEventReservoirManager
implements ReservoirManager<SpanEvent> {
    private final ConfigService configService;
    private ConcurrentHashMap<String, SamplingPriorityQueue<SpanEvent>> spanReservoirsForApp = new ConcurrentHashMap();
    private volatile int maxSamplesStored;
    private static final Comparator<SpanEvent> SPAN_EVENT_COMPARATOR = (left, right) -> ComparisonChain.start().compare(right.getPriority(), left.getPriority()).result();

    public CollectorSpanEventReservoirManager(ConfigService configService) {
        this.configService = configService;
        this.maxSamplesStored = configService.getDefaultAgentConfig().getSpanEventsConfig().getMaxSamplesStored();
    }

    @Override
    public SamplingPriorityQueue<SpanEvent> getOrCreateReservoir(String appName) {
        SamplingPriorityQueue<SpanEvent> reservoir = this.spanReservoirsForApp.get(appName);
        if (reservoir == null && (reservoir = this.spanReservoirsForApp.putIfAbsent(appName, this.createDistributedSamplingReservoir(appName, 0))) == null) {
            reservoir = this.spanReservoirsForApp.get(appName);
        }
        return reservoir;
    }

    private SamplingPriorityQueue<SpanEvent> createDistributedSamplingReservoir(String appName, int decidedLast) {
        SpanEventsConfig spanEventsConfig = this.configService.getDefaultAgentConfig().getSpanEventsConfig();
        int target = spanEventsConfig.getTargetSamplesStored();
        return new DistributedSamplingPriorityQueue<SpanEvent>(appName, "Span Event Service", this.maxSamplesStored, decidedLast, target, SPAN_EVENT_COMPARATOR);
    }

    @Override
    public void clearReservoir() {
        this.spanReservoirsForApp.clear();
    }

    @Override
    public ReservoirManager.HarvestResult attemptToSendReservoir(String appName, ReservoirManager.EventSender<SpanEvent> eventSender, Logger logger) {
        if (this.getMaxSamplesStored() <= 0) {
            this.clearReservoir();
            return null;
        }
        SpanEventsConfig config = this.configService.getAgentConfig(appName).getSpanEventsConfig();
        int decidedLast = AdaptiveSampling.decidedLast(this.spanReservoirsForApp.get(appName), config.getTargetSamplesStored());
        SamplingPriorityQueue<SpanEvent> toSend = this.spanReservoirsForApp.get(appName);
        this.spanReservoirsForApp.put(appName, this.createDistributedSamplingReservoir(appName, decidedLast));
        if (toSend == null || toSend.size() <= 0) {
            return null;
        }
        try {
            eventSender.sendEvents(appName, config.getMaxSamplesStored(), toSend.getNumberOfTries(), Collections.unmodifiableList(toSend.asList()));
            if (toSend.size() < toSend.getNumberOfTries()) {
                int dropped = toSend.getNumberOfTries() - toSend.size();
                logger.log(Level.FINE, "Dropped {0} span events out of {1}.", (Object)dropped, (Object)toSend.getNumberOfTries());
            }
            return new ReservoirManager.HarvestResult(toSend.getNumberOfTries(), toSend.size());
        }
        catch (HttpError e) {
            if (!e.discardHarvestData()) {
                logger.log(Level.FINE, "Unable to send span events. Unsent events will be included in the next harvest.", (Object)e);
                this.spanReservoirsForApp.get(appName).retryAll(toSend);
            } else {
                toSend.clear();
                logger.log(Level.FINE, "Unable to send span events. Unsent events will be dropped.", (Object)e);
            }
        }
        catch (Exception e) {
            toSend.clear();
            logger.log(Level.FINE, "Unable to send span events. Unsent events will be dropped.", (Object)e);
        }
        return null;
    }

    @Override
    public int getMaxSamplesStored() {
        return this.maxSamplesStored;
    }

    @Override
    public void setMaxSamplesStored(int newMax) {
        this.maxSamplesStored = newMax;
        ConcurrentHashMap newMaxSpanReservoirs = new ConcurrentHashMap();
        this.spanReservoirsForApp.forEach((appName, reservoir) -> newMaxSpanReservoirs.putIfAbsent(appName, this.createDistributedSamplingReservoir((String)appName, 0)));
        this.spanReservoirsForApp = newMaxSpanReservoirs;
    }
}

