/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.logging.IAgentLogger;
import com.newrelic.agent.profile.IProfile;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.profile.ProfileData;
import com.newrelic.agent.profile.ProfileSampler;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.profile.ProfilerService;
import com.newrelic.agent.service.ServiceFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class ProfileSession {
    private final ProfileSampler profileSampler = new ProfileSampler();
    private final IProfile profile;
    private final List<IProfile> profiles = new ArrayList<IProfile>();
    private final ProfilerService profilerService;
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final AtomicReference<ScheduledFuture<?>> profileHandle = new AtomicReference();
    private final AtomicReference<ScheduledFuture<?>> timeoutHandle = new AtomicReference();

    public ProfileSession(ProfilerService profilerService, ProfilerParameters profilerParameters) {
        this.profilerService = profilerService;
        this.profile = this.createProfile(profilerParameters);
        this.profile.start();
        this.profiles.add(this.profile);
    }

    private IProfile createProfile(ProfilerParameters profilerParameters) {
        return new Profile(profilerParameters);
    }

    void start() {
        long durationInMillis;
        long samplePeriodInMillis = this.profile.getProfilerParameters().getSamplePeriodInMillis();
        if (samplePeriodInMillis == (durationInMillis = this.profile.getProfilerParameters().getDurationInMillis().longValue())) {
            this.getLogger().info("Starting single sample profiling session");
            this.startSingleSample();
        } else {
            this.getLogger().info(MessageFormat.format("Starting profiling session. Duration: {0} ms, sample period: {1} ms", durationInMillis, samplePeriodInMillis));
            this.startMultiSample(samplePeriodInMillis, durationInMillis);
        }
    }

    private void startMultiSample(long samplePeriodInMillis, long durationInMillis) {
        ScheduledExecutorService scheduler = this.profilerService.getScheduledExecutorService();
        ScheduledFuture<?> handle = scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ProfileSession.this.profileSampler.sampleStackTraces(ProfileSession.this.profiles);
                }
                catch (Throwable t2) {
                    String msg = MessageFormat.format("An error occurred collecting a thread sample: {0}", t2.toString());
                    if (ProfileSession.this.getLogger().isLoggable(Level.FINER)) {
                        ProfileSession.this.getLogger().log(Level.SEVERE, msg, t2);
                    }
                    ProfileSession.this.getLogger().severe(msg);
                }
            }
        }, 0L, samplePeriodInMillis, TimeUnit.MILLISECONDS);
        this.profileHandle.set(handle);
        handle = scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                ((ScheduledFuture)ProfileSession.this.profileHandle.get()).cancel(false);
                if (!ProfileSession.this.done.getAndSet(true)) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, durationInMillis, TimeUnit.MILLISECONDS);
        this.timeoutHandle.set(handle);
    }

    private void startSingleSample() {
        ScheduledExecutorService scheduler = this.profilerService.getScheduledExecutorService();
        ScheduledFuture<?> handle = scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    ProfileSession.this.profileSampler.sampleStackTraces(ProfileSession.this.profiles);
                }
                catch (Throwable t2) {
                    String msg = MessageFormat.format("An error occurred collecting a thread sample: {0}", t2.toString());
                    if (ProfileSession.this.getLogger().isLoggable(Level.FINER)) {
                        ProfileSession.this.getLogger().log(Level.SEVERE, msg, t2);
                    }
                    ProfileSession.this.getLogger().severe(msg);
                }
                if (!ProfileSession.this.done.getAndSet(true)) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, 0L, TimeUnit.MILLISECONDS);
        this.profileHandle.set(handle);
    }

    private void report() {
        try {
            this.profile.end();
            this.profile.markInstrumentedMethods();
            this.getLogger().info(MessageFormat.format("Profiler finished with {0} samples", this.profile.getSampleCount()));
        }
        catch (Throwable e) {
            this.getLogger().log(Level.SEVERE, "Error finishing profile - no profiles will be sent", e);
            return;
        }
        ArrayList<ProfileData> data = new ArrayList<ProfileData>();
        data.addAll(this.profiles);
        try {
            List<Long> ids = ServiceFactory.getRPMService().sendProfileData(data);
            this.getLogger().info(MessageFormat.format("Server profile ids: {0}", ids));
        }
        catch (IgnoreSilentlyException ids) {
        }
        catch (Throwable e) {
            String msg = MessageFormat.format("Unable to send profile data: {0}", e.toString());
            if (this.getLogger().isLoggable(Level.FINER)) {
                this.getLogger().log(Level.SEVERE, msg, e);
            }
            this.getLogger().severe(msg);
        }
    }

    private void sessionCompleted() {
        this.profilerService.sessionCompleted(this);
    }

    void stop(final boolean shouldReport) {
        if (this.done.getAndSet(true)) {
            return;
        }
        this.getLogger().log(Level.INFO, "Stopping profiling session");
        ScheduledFuture<?> handle = this.profileHandle.get();
        if (handle != null) {
            handle.cancel(false);
        }
        if ((handle = this.timeoutHandle.get()) != null) {
            handle.cancel(false);
        }
        this.profilerService.getScheduledExecutorService().schedule(new Runnable(){

            @Override
            public void run() {
                if (shouldReport) {
                    ProfileSession.this.report();
                }
                ProfileSession.this.sessionCompleted();
            }
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public boolean isDone() {
        return this.done.get();
    }

    public Long getProfileId() {
        return this.profile.getProfileId();
    }

    public IProfile getProfile() {
        return this.profile;
    }

    private IAgentLogger getLogger() {
        return this.profilerService.getLogger();
    }
}

