/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.validation.validators;

import com.newrelic.agent.deps.org.apache.logging.log4j.Logger;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.validation.ConstraintValidator;
import com.newrelic.agent.deps.org.apache.logging.log4j.core.config.plugins.validation.constraints.ValidHost;
import com.newrelic.agent.deps.org.apache.logging.log4j.status.StatusLogger;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ValidHostValidator
implements ConstraintValidator<ValidHost> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private ValidHost annotation;

    @Override
    public void initialize(ValidHost annotation) {
        this.annotation = annotation;
    }

    @Override
    public boolean isValid(String name, Object value) {
        if (value == null) {
            LOGGER.error(this.annotation.message());
            return false;
        }
        if (value instanceof InetAddress) {
            return true;
        }
        try {
            InetAddress.getByName(value.toString());
            return true;
        }
        catch (UnknownHostException e) {
            LOGGER.error(this.annotation.message(), (Throwable)e);
            return false;
        }
    }
}

