/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent;

import com.newrelic.api.agent.DestinationType;
import com.newrelic.api.agent.ExternalParameters;
import com.newrelic.api.agent.InboundHeaders;

public class MessageConsumeParameters
implements ExternalParameters {
    private final String library;
    private final String otelLibrary;
    private final DestinationType destinationType;
    private final String destinationName;
    private final InboundHeaders inboundHeaders;
    private final String cloudAccountId;
    private final String cloudRegion;
    private final String host;
    private final Integer port;

    private MessageConsumeParameters(Builder builder) {
        this.library = builder.library;
        this.otelLibrary = builder.otelLibrary;
        this.destinationType = builder.destinationType;
        this.destinationName = builder.destinationName;
        this.inboundHeaders = builder.inboundHeaders;
        this.cloudAccountId = builder.cloudAccountId;
        this.cloudRegion = builder.cloudRegion;
        this.host = builder.host;
        this.port = builder.port;
    }

    @Deprecated
    protected MessageConsumeParameters(String library, DestinationType destinationType, String destinationName, InboundHeaders inboundHeaders) {
        this.library = library;
        this.otelLibrary = null;
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.inboundHeaders = inboundHeaders;
        this.cloudAccountId = null;
        this.cloudRegion = null;
        this.host = null;
        this.port = null;
    }

    protected MessageConsumeParameters(MessageConsumeParameters messageConsumeParameters) {
        this.library = messageConsumeParameters.library;
        this.otelLibrary = messageConsumeParameters.otelLibrary;
        this.destinationType = messageConsumeParameters.destinationType;
        this.destinationName = messageConsumeParameters.destinationName;
        this.inboundHeaders = messageConsumeParameters.inboundHeaders;
        this.cloudAccountId = messageConsumeParameters.cloudAccountId;
        this.cloudRegion = messageConsumeParameters.cloudRegion;
        this.host = messageConsumeParameters.host;
        this.port = messageConsumeParameters.port;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public DestinationType getDestinationType() {
        return this.destinationType;
    }

    public InboundHeaders getInboundHeaders() {
        return this.inboundHeaders;
    }

    public String getCloudAccountId() {
        return this.cloudAccountId;
    }

    public String getCloudRegion() {
        return this.cloudRegion;
    }

    public String getLibrary() {
        return this.library;
    }

    public String getOtelLibrary() {
        return this.otelLibrary;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public static DestinationTypeParameter library(String library) {
        return new Builder(library);
    }

    public static DestinationTypeParameter library(String library, String otelLibrary) {
        return new Builder(library).otelLibrary(otelLibrary);
    }

    public static interface Build {
        public Build cloudAccountId(String var1);

        public Build cloudRegion(String var1);

        public Build instance(String var1, Integer var2);

        public MessageConsumeParameters build();
    }

    public static interface InboundHeadersParameter {
        public Build inboundHeaders(InboundHeaders var1);
    }

    public static interface DestinationNameParameter {
        public InboundHeadersParameter destinationName(String var1);
    }

    public static interface DestinationTypeParameter {
        public DestinationNameParameter destinationType(DestinationType var1);
    }

    protected static class Builder
    implements DestinationTypeParameter,
    DestinationNameParameter,
    InboundHeadersParameter,
    Build {
        private String library;
        private String otelLibrary;
        private DestinationType destinationType;
        private String destinationName;
        private InboundHeaders inboundHeaders;
        private String cloudAccountId;
        private String cloudRegion;
        private String host;
        private Integer port;

        public Builder(String library) {
            this.library = library;
        }

        public DestinationTypeParameter otelLibrary(String otelLibrary) {
            this.otelLibrary = otelLibrary;
            return this;
        }

        @Override
        public DestinationNameParameter destinationType(DestinationType destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public InboundHeadersParameter destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        @Override
        public Build inboundHeaders(InboundHeaders inboundHeaders) {
            this.inboundHeaders = inboundHeaders;
            return this;
        }

        @Override
        public Build cloudAccountId(String cloudAccountId) {
            this.cloudAccountId = cloudAccountId;
            return this;
        }

        @Override
        public Build cloudRegion(String cloudRegion) {
            this.cloudRegion = cloudRegion;
            return this;
        }

        @Override
        public Build instance(String host, Integer port) {
            this.host = host;
            this.port = port;
            return this;
        }

        @Override
        public MessageConsumeParameters build() {
            return new MessageConsumeParameters(this);
        }
    }
}

