/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.service;

import com.newrelic.agent.RPMServiceManager;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.environment.EnvironmentService;
import com.newrelic.agent.errors.ErrorAnalyzerImpl;
import com.newrelic.agent.errors.ErrorMessageReplacer;
import com.newrelic.agent.interfaces.ReservoirManager;
import com.newrelic.agent.model.SpanEvent;
import com.newrelic.agent.service.ReservoirAddingSpanEventConsumer;
import com.newrelic.agent.service.analytics.CollectorSpanEventReservoirManager;
import com.newrelic.agent.service.analytics.CollectorSpanEventSender;
import com.newrelic.agent.service.analytics.InfiniteTracingEnabledCheck;
import com.newrelic.agent.service.analytics.SpanErrorBuilder;
import com.newrelic.agent.service.analytics.SpanEventCreationDecider;
import com.newrelic.agent.service.analytics.SpanEventsService;
import com.newrelic.agent.service.analytics.SpanEventsServiceImpl;
import com.newrelic.agent.service.analytics.TracerToSpanEvent;
import com.newrelic.agent.service.analytics.TransactionDataToDistributedTraceIntrinsics;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class SpanEventsServiceFactory {
    private final ConfigService configService;
    private final RPMServiceManager rpmServiceManager;
    private final InfiniteTracingEnabledCheck infiniteTracingEnabledCheck;
    private final TransactionService transactionService;
    private final ReservoirManager<SpanEvent> reservoirManager;
    private final Consumer<SpanEvent> infiniteTracingConsumer;
    private final SpanEventCreationDecider spanEventCreationDecider;
    private final EnvironmentService environmentService;
    private final TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics;

    private SpanEventsServiceFactory(Builder builder) {
        this.configService = builder.configService;
        this.rpmServiceManager = builder.rpmServiceManager;
        this.infiniteTracingConsumer = builder.infiniteTracingConsumer;
        this.infiniteTracingEnabledCheck = builder.infiniteTracingEnabledCheck;
        this.transactionService = builder.transactionService;
        this.reservoirManager = builder.reservoirManager;
        this.spanEventCreationDecider = builder.spanEventCreationDecider;
        this.environmentService = builder.environmentService;
        this.transactionDataToDistributedTraceIntrinsics = builder.transactionDataToDistributedTraceIntrinsics;
    }

    public SpanEventsService build() {
        CollectorSpanEventSender collectorSpanEventSender = new CollectorSpanEventSender(this.rpmServiceManager);
        AgentConfig agentConfig = this.configService.getDefaultAgentConfig();
        Consumer<SpanEvent> eventStorageBackend = this.buildStorageBackendConsumer(this.reservoirManager);
        SpanErrorBuilder defaultSpanErrorBuilder = this.buildDefaultSpanErrorBuilder(agentConfig);
        Map<String, SpanErrorBuilder> errorBuilderForApp = this.buildSpanEventErrorBuilder(agentConfig, defaultSpanErrorBuilder);
        this.configureUpdateOnConfigChange(errorBuilderForApp);
        TracerToSpanEvent tracerToSpanEvent = new TracerToSpanEvent(errorBuilderForApp, this.environmentService, this.transactionDataToDistributedTraceIntrinsics, defaultSpanErrorBuilder);
        SpanEventsServiceImpl result = SpanEventsServiceImpl.builder().agentConfig(agentConfig).reservoirManager(this.reservoirManager).collectorSender(collectorSpanEventSender).eventBackendStorage(eventStorageBackend).spanEventCreationDecider(this.spanEventCreationDecider).tracerToSpanEvent(tracerToSpanEvent).build();
        this.configService.addIAgentConfigListener(result);
        this.transactionService.addTransactionListener(result);
        return result;
    }

    private void configureUpdateOnConfigChange(Map<String, SpanErrorBuilder> errorBuilderForApp) {
        this.configService.addIAgentConfigListener((appName, agentConfig) -> errorBuilderForApp.put(agentConfig.getApplicationName(), new SpanErrorBuilder(new ErrorAnalyzerImpl(agentConfig.getErrorCollectorConfig()), new ErrorMessageReplacer(agentConfig.getStripExceptionConfig()))));
    }

    private Map<String, SpanErrorBuilder> buildSpanEventErrorBuilder(AgentConfig agentConfig, SpanErrorBuilder spanErrorBuilder) {
        HashMap<String, SpanErrorBuilder> result = new HashMap<String, SpanErrorBuilder>();
        result.put(agentConfig.getApplicationName(), spanErrorBuilder);
        return result;
    }

    private SpanErrorBuilder buildDefaultSpanErrorBuilder(AgentConfig agentConfig) {
        return new SpanErrorBuilder(new ErrorAnalyzerImpl(agentConfig.getErrorCollectorConfig()), new ErrorMessageReplacer(agentConfig.getStripExceptionConfig()));
    }

    private Consumer<SpanEvent> buildStorageBackendConsumer(ReservoirManager<SpanEvent> reservoirManager) {
        if (this.infiniteTracingEnabledCheck.isEnabled()) {
            return this.infiniteTracingConsumer;
        }
        return new ReservoirAddingSpanEventConsumer(reservoirManager, this.configService);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ConfigService configService;
        private RPMServiceManager rpmServiceManager;
        private Consumer<SpanEvent> infiniteTracingConsumer;
        private InfiniteTracingEnabledCheck infiniteTracingEnabledCheck;
        private TransactionService transactionService;
        private ReservoirManager<SpanEvent> reservoirManager;
        private SpanEventCreationDecider spanEventCreationDecider;
        private EnvironmentService environmentService;
        private TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics;

        public Builder configService(ConfigService configService) {
            this.configService = configService;
            return this;
        }

        public Builder rpmServiceManager(RPMServiceManager rpmServiceManager) {
            this.rpmServiceManager = rpmServiceManager;
            return this;
        }

        public Builder infiniteTracingConsumer(Consumer<SpanEvent> infiniteTracingConsumer) {
            this.infiniteTracingConsumer = infiniteTracingConsumer;
            return this;
        }

        public Builder transactionService(TransactionService transactionService) {
            this.transactionService = transactionService;
            return this;
        }

        public Builder reservoirManager(ReservoirManager<SpanEvent> reservoirManager) {
            this.reservoirManager = reservoirManager;
            return this;
        }

        public Builder spanEventCreationDecider(SpanEventCreationDecider spanEventCreationDecider) {
            this.spanEventCreationDecider = spanEventCreationDecider;
            return this;
        }

        public Builder environmentService(EnvironmentService environmentService) {
            this.environmentService = environmentService;
            return this;
        }

        public Builder transactionDataToDistributedTraceIntrinsics(TransactionDataToDistributedTraceIntrinsics transactionDataToDistributedTraceIntrinsics) {
            this.transactionDataToDistributedTraceIntrinsics = transactionDataToDistributedTraceIntrinsics;
            return this;
        }

        public SpanEventsService build() {
            this.infiniteTracingEnabledCheck = this.infiniteTracingEnabledCheck == null ? new InfiniteTracingEnabledCheck(this.configService) : this.infiniteTracingEnabledCheck;
            this.reservoirManager = this.reservoirManager == null ? new CollectorSpanEventReservoirManager(this.configService) : this.reservoirManager;
            return new SpanEventsServiceFactory(this).build();
        }
    }
}

