/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.Caffeine;
import com.newrelic.agent.deps.com.github.benmanes.caffeine.cache.LoadingCache;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.profile.v2.Profile;
import com.newrelic.agent.profile.v2.ProfileTree;
import com.newrelic.agent.threads.BasicThreadInfo;
import com.newrelic.agent.threads.ThreadNameNormalizer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DiscoveryProfile
implements JSONStreamAware {
    private final LoadingCache<Object, ProfileTree> discoveryProfileTrees;
    private final ThreadNameNormalizer threadNameNormalizer;
    private final Profile profile;

    public DiscoveryProfile(Profile profile, ThreadNameNormalizer threadNameNormalizer) {
        this.threadNameNormalizer = threadNameNormalizer;
        this.profile = profile;
        this.discoveryProfileTrees = Caffeine.newBuilder().executor(Runnable::run).build(threadNameKey -> new ProfileTree(this.profile, false));
    }

    public void noticeStartTracer(int signatureId) {
        String threadName = this.threadNameNormalizer.getNormalizedThreadName(new BasicThreadInfo(Thread.currentThread()));
        Object key = this.profile.getStringMap().addString(threadName);
        this.discoveryProfileTrees.get(key).addStackTrace(DiscoveryProfile.getScrubbedCurrentThreadStackTrace(), true);
    }

    static List<StackTraceElement> getScrubbedCurrentThreadStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> stackTraceList = DiscoveryProfile.getScrubbedStackTrace(Arrays.asList(stackTrace));
        Collections.reverse(stackTraceList);
        return stackTraceList;
    }

    static List<StackTraceElement> getScrubbedStackTrace(Collection<StackTraceElement> stackTrace) {
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>(stackTrace.size());
        boolean nonAgent = false;
        for (StackTraceElement e : stackTrace) {
            if (!nonAgent && (!DiscoveryProfile.isNotAgent(e) || !DiscoveryProfile.isNotThreadGetStackTrace(e))) continue;
            nonAgent = true;
            list.add(e);
        }
        return list;
    }

    private static boolean isNotAgent(StackTraceElement e) {
        return !e.getClassName().startsWith("com.newrelic.agent");
    }

    private static boolean isNotThreadGetStackTrace(StackTraceElement e) {
        return !"java.lang.Thread".equals(e.getClassName()) || !"getStackTrace".equals(e.getMethodName());
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONObject.writeJSONString(this.discoveryProfileTrees.asMap(), out);
    }
}

