/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.model;

import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.model.AnalyticsEvent;
import com.newrelic.agent.model.SpanCategory;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SpanEvent
extends AnalyticsEvent
implements JSONStreamAware {
    public static final String SPAN = "Span";
    static final String CLIENT_SPAN_KIND = "client";
    private final String appName;
    private final Map<String, Object> intrinsics;
    private final Map<String, Object> agentAttributes;
    private final boolean decider;

    private SpanEvent(Builder builder) {
        super(SPAN, builder.timestamp, builder.priority, builder.userAttributes);
        this.appName = builder.appName;
        this.agentAttributes = builder.agentAttributes;
        this.decider = builder.decider;
        this.intrinsics = builder.intrinsics;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> getIntrinsics() {
        return this.intrinsics;
    }

    public String getAppName() {
        return this.appName;
    }

    public Map<String, Object> getAgentAttributes() {
        return this.agentAttributes;
    }

    @Override
    public boolean decider() {
        return this.decider;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.intrinsics, this.getMutableUserAttributes(), this.getAgentAttributes()), out);
    }

    public String getTraceId() {
        return (String)this.intrinsics.get("traceId");
    }

    public String getGuid() {
        return (String)this.intrinsics.get("guid");
    }

    public String getParentId() {
        return (String)this.intrinsics.get("parentId");
    }

    public String getName() {
        return (String)this.intrinsics.get("name");
    }

    public float getDuration() {
        return ((Float)this.intrinsics.get("duration")).floatValue();
    }

    public String getTransactionId() {
        return (String)this.intrinsics.get("transactionId");
    }

    public SpanCategory getCategory() {
        return SpanCategory.fromString((String)this.intrinsics.get("category"));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanEvent spanEvent = (SpanEvent)o;
        return this.decider == spanEvent.decider && Objects.equals(this.appName, spanEvent.appName) && Objects.equals(this.intrinsics, spanEvent.intrinsics) && Objects.equals(this.agentAttributes, spanEvent.agentAttributes) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appName, this.intrinsics, this.agentAttributes, this.decider);
    }

    public static class Builder {
        private final Map<String, Object> intrinsics = new HashMap<String, Object>();
        private final Map<String, Object> agentAttributes = new HashMap<String, Object>();
        private final Map<String, Object> userAttributes = new HashMap<String, Object>();
        private String appName;
        private float priority;
        private boolean decider;
        private long timestamp;
        private Object spanKind;

        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        public Builder priority(float priority) {
            this.priority = priority;
            return this;
        }

        public Builder putIntrinsic(String key, Object value) {
            if (key != null && value != null) {
                this.intrinsics.put(key, value);
            }
            return this;
        }

        public Builder putAllIntrinsics(Map<String, ?> intrinsicAttributes) {
            this.intrinsics.putAll(intrinsicAttributes);
            return this;
        }

        public Builder putAllAgentAttributes(Map<String, ?> agentAttributes) {
            this.agentAttributes.putAll(agentAttributes);
            return this;
        }

        public Builder putAllUserAttributes(Map<String, ?> userAttributes) {
            if (userAttributes == null || userAttributes.isEmpty()) {
                return this;
            }
            for (Map.Entry<String, ?> entry : userAttributes.entrySet()) {
                this.userAttributes.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder putAllUserAttributesIfAbsent(Map<String, ?> userAttributes) {
            if (userAttributes == null || userAttributes.isEmpty()) {
                return this;
            }
            for (Map.Entry<String, ?> entry : userAttributes.entrySet()) {
                if (this.userAttributes.containsKey(entry.getKey())) continue;
                this.userAttributes.put(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder putAgentAttribute(String key, Object value) {
            if (key != null && value != null) {
                this.agentAttributes.put(key, value);
            }
            return this;
        }

        public Builder spanKind(Object spanKind) {
            this.putIntrinsic("span.kind", spanKind);
            this.spanKind = spanKind;
            return this;
        }

        public boolean isClientSpan() {
            return SpanEvent.CLIENT_SPAN_KIND.equals(this.spanKind);
        }

        public Object getSpanKindFromUserAttributes() {
            Object result = this.userAttributes.get("span.kind");
            return result == null ? SpanEvent.CLIENT_SPAN_KIND : result;
        }

        public Builder decider(boolean decider) {
            this.decider = decider;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SpanEvent build() {
            if (this.timestamp == 0L) {
                this.timestamp = System.currentTimeMillis();
            }
            return new SpanEvent(this);
        }
    }
}

