/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.agent.tracing.DistributedTraceUtil;
import com.newrelic.api.agent.DistributedTracePayload;
import com.newrelic.api.agent.NewRelic;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class SpanProxy {
    private volatile long timestamp;
    private volatile long transportDurationInMillis;
    private final AtomicReference<DistributedTracePayloadImpl> inboundPayloadData = new AtomicReference<Object>(null);
    private final AtomicReference<DistributedTracePayloadImpl> outboundPayloadData = new AtomicReference<Object>(null);

    public DistributedTracePayload createDistributedTracePayload() {
        String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
        String guid = TransactionGuidFactory.generateGuid();
        return this.createDistributedTracePayload(this.inboundPayloadData.get() == null ? guid : this.inboundPayloadData.get().guid, DistributedTraceUtil.getPriority(defaultAppName).get(), guid, null);
    }

    public DistributedTracePayload createDistributedTracePayload(String traceId, Float priority, String guid, String txnId) {
        try {
            DistributedTracePayloadImpl payload = DistributedTracePayloadImpl.createDistributedTracePayload(this.inboundPayloadData.get(), traceId, guid, txnId, priority.floatValue());
            if (payload == null) {
                return null;
            }
            if (Agent.LOG.isFinestEnabled()) {
                Agent.LOG.log(Level.FINEST, "Created distributed trace payload: {0} for transaction: {1}", payload, this);
            }
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/CreatePayload/Success");
            this.outboundPayloadData.compareAndSet(null, payload);
            return payload;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Unable to create distributed trace payload");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/CreatePayload/Exception");
            return null;
        }
    }

    public boolean acceptDistributedTracePayload(String payload) {
        try {
            DistributedTracePayloadImpl parsedPayload = DistributedTracePayloadImpl.parseDistributedTracePayload(this.outboundPayloadData.get(), payload);
            return parsedPayload != null && this.acceptDistributedTracePayloadImpl(parsedPayload);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Unable to accept distributed trace payload: {0}", payload);
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Exception");
            return false;
        }
    }

    public boolean acceptDistributedTracePayload(DistributedTracePayload payload) {
        try {
            if (this.outboundPayloadData.get() != null) {
                Agent.LOG.log(Level.WARNING, "Error: createDistributedTracePayload was called before acceptDistributedTracePayload. Ignoring Call");
                NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/CreateBeforeAccept");
                return false;
            }
            if (payload instanceof DistributedTracePayloadImpl) {
                return this.acceptDistributedTracePayloadImpl((DistributedTracePayloadImpl)payload);
            }
            Agent.LOG.log(Level.FINEST, "Unable to accept distributed trace payload. Incorrect type: {0}", payload.getClass().getName());
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Unable to accept distributed trace payload: {0}", payload);
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Exception");
        }
        return false;
    }

    private boolean acceptDistributedTracePayloadImpl(DistributedTracePayloadImpl payload) {
        if (this.inboundPayloadData.compareAndSet(null, payload)) {
            this.transportDurationInMillis = this.timestamp - payload.timestamp;
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Success");
            return true;
        }
        NewRelic.incrementCounter((String)"Supportability/DistributedTrace/AcceptPayload/Ignored/Multiple");
        return false;
    }

    public DistributedTracePayloadImpl getInboundDistributedTracePayload() {
        return this.inboundPayloadData.get();
    }

    public DistributedTracePayloadImpl getOutboundDistributedTracePayload() {
        return this.outboundPayloadData.get();
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getTransportDurationInMillis() {
        return this.transportDurationInMillis;
    }
}

