/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.api.agent.tracing.NewRelicSpan;
import com.newrelic.api.agent.tracing.NewRelicSpanContext;
import com.newrelic.api.agent.tracing.NewRelicTracer;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class NewRelicSpanBuilder
implements com.newrelic.api.agent.NewRelicSpanBuilder {
    private long startTimeInMillis;
    private long startTimeInNanos;
    private boolean ignoreActiveSpan = false;
    private SpanContext parent;
    private final String operationName;
    private final AtomicReference<Map<String, Object>> tags = new AtomicReference<Object>(null);

    NewRelicSpanBuilder(String operationName) {
        this.operationName = operationName;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(Span parent) {
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
        if (this.parent == null && (referenceType.equals("child_of") || referenceType.equals("follows_from"))) {
            this.parent = referencedContext;
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        this.tags.compareAndSet(null, new ConcurrentHashMap());
        this.tags.get().put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        this.tags.compareAndSet(null, new ConcurrentHashMap());
        this.tags.get().put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        this.tags.compareAndSet(null, new ConcurrentHashMap());
        this.tags.get().put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.startTimeInMillis = TimeUnit.MICROSECONDS.toMillis(microseconds);
        this.startTimeInNanos = TimeUnit.MICROSECONDS.toNanos(microseconds);
        return this;
    }

    public Scope startActive(boolean finishSpanOnClose) {
        return NewRelicTracer.INSTANCE.scopeManager().activate(this.startManual(), finishSpanOnClose);
    }

    public Span start() {
        return this.startManual();
    }

    public Span startManual() {
        Span activeSpan = AgentBridge.getTracer().activeSpan();
        long startTimeInMillis = this.startTimeInMillis == 0L ? System.currentTimeMillis() : this.startTimeInMillis;
        long startTimeInNanos = this.startTimeInNanos == 0L ? System.nanoTime() : this.startTimeInNanos;
        com.newrelic.agent.bridge.Span currentSpan = AgentBridge.getAgent().startSpan(this.operationName);
        NewRelicSpanContext parentSpanContext = null;
        if (!this.ignoreActiveSpan && this.parent == null && activeSpan != null) {
            this.addReference("child_of", activeSpan.context());
        }
        if (!this.ignoreActiveSpan && this.parent != null) {
            parentSpanContext = (NewRelicSpanContext)this.parent;
            currentSpan.acceptDistributedTracePayload(parentSpanContext.getOrCreatePayload());
        }
        NewRelicSpanContext spanContext = new NewRelicSpanContext(currentSpan, parentSpanContext);
        return new NewRelicSpan(this.operationName, startTimeInMillis, startTimeInNanos, this.tags.get(), spanContext);
    }
}

