/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.api.agent.tracing.NewRelicSpanContext;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class NewRelicSpan
implements com.newrelic.api.agent.NewRelicSpan {
    private String operationName;
    private final NewRelicSpanContext context;
    private final long startTimeInMicros;
    private final long startTimeInNanos;
    private final AtomicReference<Map<String, Object>> tags = new AtomicReference<Object>(null);
    private final AtomicReference<Map<String, Object>> logs = new AtomicReference<Object>(null);
    private final AtomicReference<Map<String, String>> baggage = new AtomicReference<Object>(null);

    NewRelicSpan(String operationName, long startTimeInMillis, long startTimeInNanos, Map<String, Object> tags, NewRelicSpanContext context) {
        this.context = context;
        this.operationName = operationName;
        this.startTimeInMicros = TimeUnit.MILLISECONDS.toMicros(startTimeInMillis);
        this.startTimeInNanos = startTimeInNanos;
        this.tags.set(tags);
        this.baggage.set(context.getBaggage());
    }

    public SpanContext context() {
        return this.context;
    }

    public Span setTag(String key, String value) {
        this.tags.compareAndSet(null, new ConcurrentHashMap());
        this.tags.get().put(key, value);
        return this;
    }

    public Span setTag(String key, boolean value) {
        this.tags.compareAndSet(null, new ConcurrentHashMap());
        this.tags.get().put(key, value);
        return this;
    }

    public Span setTag(String key, Number value) {
        this.tags.compareAndSet(null, new ConcurrentHashMap());
        this.tags.get().put(key, value);
        return this;
    }

    public Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    public Span log(Map<String, ?> fields) {
        return this.log(this.getEpochTimestampMicroseconds(System.nanoTime()), fields);
    }

    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            this.log(timestampMicroseconds, entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Span log(String event) {
        return this.log(this.getEpochTimestampMicroseconds(System.nanoTime()), event);
    }

    public Span log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, "event", event);
    }

    private Span log(long timestampMicroseconds, String eventName, Object payload) {
        this.logs.compareAndSet(null, new ConcurrentHashMap());
        this.logs.get().put(eventName, payload);
        return this;
    }

    private long getEpochTimestampMicroseconds(long nanoTime) {
        long microsSinceStart = TimeUnit.NANOSECONDS.toMicros(nanoTime - this.startTimeInNanos);
        return this.startTimeInMicros + microsSinceStart;
    }

    public Span setBaggageItem(String key, String value) {
        this.baggage.compareAndSet(null, new ConcurrentHashMap());
        this.baggage.get().put(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.baggage.get() == null ? null : this.baggage.get().get(key);
    }

    public void finish() {
        this.finish(this.getEpochTimestampMicroseconds(System.nanoTime()));
    }

    public void finish(long finishMicros) {
        try {
            NewRelicSpanContext context = (NewRelicSpanContext)this.context();
            if (context == null) {
                AgentBridge.getAgent().getLogger().log(Level.FINER, "Unable to finish span: {0} due to missing context", (Object)this);
                return;
            }
            com.newrelic.agent.bridge.Span span = context.getSpan();
            HashMap attributes = this.tags.get() != null ? Maps.newHashMap(this.tags.get()) : Maps.newHashMap();
            span.addCustomParameters(attributes);
            span.finish();
            AgentBridge.getAgent().getLogger().log(Level.FINEST, "Finish span: {0}, event: {1}", (Object)this, (Object)span);
        }
        catch (Throwable t) {
            AgentBridge.getAgent().getLogger().log(Level.SEVERE, t, "Unable to finish span: {0}", (Object)this);
        }
    }

    public String toString() {
        return "NewRelicSpan{startTimeInMicros=" + this.startTimeInMicros + ", operationName='" + this.operationName + '\'' + ", tags=" + this.tags.get() + ", logs=" + this.logs.get() + ", baggage=" + this.baggage.get() + '}';
    }
}

