/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.deps.org.apache.http.conn.ConnectTimeoutException;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.CloudUtility;
import com.newrelic.agent.utilization.CloudVendor;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class GCP
implements CloudVendor {
    public static String PROVIDER = "gcp";
    protected static final String INSTANCE_DOCUMENT_RECURSIVE = "http://metadata.google.internal/computeMetadata/v1/instance/?recursive=true";
    private static int REQUEST_TIMEOUT_MILLIS = 100;
    private static final String GCP_ID_KEY = "id";
    private static final String GCP_MACHINE_TYPE_KEY = "machineType";
    private static final String GCP_ZONE_KEY = "zone";
    private static final String GCP_NAME_KEY = "name";

    @Override
    public GcpData getData() {
        try {
            String unparsedResultRecurse = this.getGcpValues();
            JSONParser jsonParser = new JSONParser();
            HashMap result = null;
            if (unparsedResultRecurse != null) {
                result = (JSONObject)jsonParser.parse(unparsedResultRecurse);
            }
            if (result == null || result.isEmpty()) {
                return GcpData.EMPTY_DATA;
            }
            String id = String.valueOf(result.get(GCP_ID_KEY));
            String machineType = (String)result.get(GCP_MACHINE_TYPE_KEY);
            String name = (String)result.get(GCP_NAME_KEY);
            String zone = (String)result.get(GCP_ZONE_KEY);
            if (CloudUtility.isInvalidValue(id) || CloudUtility.isInvalidValue(machineType) || CloudUtility.isInvalidValue(name) || CloudUtility.isInvalidValue(zone)) {
                Agent.LOG.log(Level.WARNING, "Failed to validate GCP value");
                GCP.recordGcpError();
                return GcpData.EMPTY_DATA;
            }
            machineType = machineType.substring(machineType.lastIndexOf(47) + 1);
            zone = zone.substring(zone.lastIndexOf(47) + 1);
            GcpData data = new GcpData(id, machineType, name, zone);
            Agent.LOG.log(Level.FINEST, "Found {0}", data);
            return data;
        }
        catch (Exception e) {
            return GcpData.EMPTY_DATA;
        }
    }

    protected String getGcpValues() {
        try {
            return CloudUtility.makeHttpRequest(INSTANCE_DOCUMENT_RECURSIVE, REQUEST_TIMEOUT_MILLIS, "Metadata-Flavor: Google");
        }
        catch (ConnectTimeoutException connectTimeoutException) {
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, MessageFormat.format("Error occurred trying to get GCP values. {0}", t));
            GCP.recordGcpError();
        }
        return null;
    }

    private static void recordGcpError() {
        CloudUtility.recordError("Supportability/utilization/gcp/error");
    }

    protected static class GcpData
    implements CloudData {
        private final String id;
        private final String machineType;
        private final String name;
        private final String zone;
        static final GcpData EMPTY_DATA = new GcpData();

        private GcpData() {
            this.id = null;
            this.machineType = null;
            this.name = null;
            this.zone = null;
        }

        protected GcpData(String id, String machineType, String name, String zone) {
            this.id = id;
            this.machineType = machineType;
            this.name = name;
            this.zone = zone;
        }

        public String getId() {
            return this.id;
        }

        public String getMachineType() {
            return this.machineType;
        }

        public String getName() {
            return this.name;
        }

        public String getZone() {
            return this.zone;
        }

        @Override
        public Map<String, String> getValueMap() {
            HashMap<String, String> gcp = new HashMap<String, String>();
            if (this.machineType == null || this.id == null || this.zone == null || this.name == null) {
                return gcp;
            }
            gcp.put(GCP.GCP_MACHINE_TYPE_KEY, this.machineType);
            gcp.put(GCP.GCP_ID_KEY, this.id);
            gcp.put(GCP.GCP_ZONE_KEY, this.zone);
            gcp.put(GCP.GCP_NAME_KEY, this.name);
            return gcp;
        }

        @Override
        public String getProvider() {
            return PROVIDER;
        }

        @Override
        public boolean isEmpty() {
            return this == EMPTY_DATA;
        }

        public String toString() {
            return "GcpData{id='" + this.id + '\'' + ", machineType='" + this.machineType + '\'' + ", name='" + this.name + '\'' + ", zone='" + this.zone + '\'' + '}';
        }
    }
}

