/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.MaxPayloadException;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.MetricDataException;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.LaspPolicies;
import com.newrelic.agent.deps.com.google.common.annotations.VisibleForTesting;
import com.newrelic.agent.deps.org.apache.http.Header;
import com.newrelic.agent.deps.org.apache.http.HttpEntity;
import com.newrelic.agent.deps.org.apache.http.HttpHost;
import com.newrelic.agent.deps.org.apache.http.StatusLine;
import com.newrelic.agent.deps.org.apache.http.auth.AuthScope;
import com.newrelic.agent.deps.org.apache.http.auth.Credentials;
import com.newrelic.agent.deps.org.apache.http.auth.UsernamePasswordCredentials;
import com.newrelic.agent.deps.org.apache.http.client.config.RequestConfig;
import com.newrelic.agent.deps.org.apache.http.client.methods.CloseableHttpResponse;
import com.newrelic.agent.deps.org.apache.http.client.methods.HttpUriRequest;
import com.newrelic.agent.deps.org.apache.http.client.methods.RequestBuilder;
import com.newrelic.agent.deps.org.apache.http.client.protocol.HttpClientContext;
import com.newrelic.agent.deps.org.apache.http.config.SocketConfig;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.SSLContextBuilder;
import com.newrelic.agent.deps.org.apache.http.conn.ssl.StrictHostnameVerifier;
import com.newrelic.agent.deps.org.apache.http.entity.ByteArrayEntity;
import com.newrelic.agent.deps.org.apache.http.impl.client.BasicCredentialsProvider;
import com.newrelic.agent.deps.org.apache.http.impl.client.CloseableHttpClient;
import com.newrelic.agent.deps.org.apache.http.impl.client.HttpClientBuilder;
import com.newrelic.agent.deps.org.apache.http.message.BasicHeader;
import com.newrelic.agent.deps.org.apache.http.protocol.HttpContext;
import com.newrelic.agent.deps.org.json.simple.JSONArray;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.deps.org.json.simple.JSONValue;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.profile.ProfileData;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.AnalyticsEvent;
import com.newrelic.agent.service.analytics.CustomInsightsEvent;
import com.newrelic.agent.service.analytics.ErrorEvent;
import com.newrelic.agent.service.analytics.SpanEvent;
import com.newrelic.agent.service.module.Jar;
import com.newrelic.agent.service.module.Module;
import com.newrelic.agent.sql.SqlTrace;
import com.newrelic.agent.stats.StatsWorks;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderListener;
import com.newrelic.agent.transport.DataSenderWriter;
import com.newrelic.agent.transport.HttpError;
import com.newrelic.agent.transport.InitialSizedJsonArray;
import com.newrelic.agent.transport.ReadResult;
import com.newrelic.agent.util.RubyConversion;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.rmi.UnexpectedException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;

public class DataSenderImpl
implements DataSender {
    private static final String MODULE_TYPE = "Jars";
    private static final int DEFAULT_REQUEST_TIMEOUT_IN_SECONDS = 120;
    private static final int PROTOCOL_VERSION = 16;
    private static final String BEFORE_LICENSE_KEY_URI_PATTERN = "/agent_listener/invoke_raw_method?method={0}";
    private static final String AFTER_LICENSE_KEY_URI_PATTERN = "&marshal_format=json&protocol_version=";
    private static final String LICENSE_KEY_URI_PATTERN = "&license_key={0}";
    private static final String RUN_ID_PATTERN = "&run_id={1}";
    private static final String CONNECT_METHOD = "connect";
    private static final String METRIC_DATA_METHOD = "metric_data";
    private static final String GET_AGENT_COMMANDS_METHOD = "get_agent_commands";
    private static final String AGENT_COMMAND_RESULTS_METHOD = "agent_command_results";
    private static final String GET_PRECONNECT_HOST_METHOD = "preconnect";
    private static final String ERROR_DATA_METHOD = "error_data";
    private static final String PROFILE_DATA_METHOD = "profile_data";
    public static final String ERROR_EVENT_DATA_METHOD = "error_event_data";
    public static final String ANALYTIC_DATA_METHOD = "analytic_event_data";
    public static final String SPAN_EVENT_DATA_METHOD = "span_event_data";
    public static final String CUSTOM_ANALYTIC_DATA_METHOD = "custom_event_data";
    private static final String UPDATE_LOADED_MODULES_METHOD = "update_loaded_modules";
    private static final String MODULE_METADATA_METHOD = "module_metadata";
    private static final String SHUTDOWN_METHOD = "shutdown";
    private static final String SQL_TRACE_DATA_METHOD = "sql_trace_data";
    private static final String TRANSACTION_SAMPLE_DATA_METHOD = "transaction_sample_data";
    private static final String USER_AGENT_HEADER_VALUE = DataSenderImpl.initUserHeaderValue();
    private static final String GZIP = "gzip";
    public static final String DEFLATE_ENCODING = "deflate";
    public static final String GZIP_ENCODING = "gzip";
    private static final String IDENTITY_ENCODING = "identity";
    private static final String RESPONSE_MAP_EXCEPTION_KEY = "exception";
    private static final String EXCEPTION_MAP_MESSAGE_KEY = "message";
    private static final String EXCEPTION_MAP_ERROR_TYPE_KEY = "error_type";
    private static final String EXCEPTION_MAP_RETURN_VALUE_KEY = "return_value";
    private static final String AGENT_RUN_ID_KEY = "agent_run_id";
    private static final String SSL_KEY = "ssl";
    private static final Object NO_AGENT_RUN_ID = null;
    private static final String NULL_RESPONSE = "null";
    private static final String TIMEOUT_PROPERTY = "timeout";
    private static final int COMPRESSION_LEVEL = -1;
    private static final String GET_XRAY_PARMS_METHOD = "get_xray_metadata";
    private static final String REDIRECT_HOST = "redirect_host";
    private static final String SECURITY_POLICIES = "security_policies";
    private static final String MAX_PAYLOAD_SIZE_IN_BYTES = "max_payload_size_in_bytes";
    private static final int DEFAULT_MAX_PAYLOAD_SIZE_IN_BYTES = 1000000;
    private volatile String host;
    private final int port;
    private volatile String protocol;
    private final HttpHost proxy;
    private final Credentials proxyCredentials;
    private final int defaultTimeoutInMillis;
    private volatile boolean auditMode;
    private Set<String> auditModeEndpoints;
    private volatile Object agentRunId = NO_AGENT_RUN_ID;
    private final String agentRunIdUriPattern;
    private final String noAgentRunIdUriPattern;
    private final boolean usePrivateSSL;
    private final String caBundlePath;
    private final boolean useSSL;
    private final SSLContext sslContext;
    private final DataSenderListener dataSenderListener;
    private final String compressedEncoding;
    private final boolean putForDataSend;
    private Map<String, Boolean> policiesJson;
    private volatile int maxPayloadSizeInBytes = 1000000;

    private static String initUserHeaderValue() {
        String arch = "unknown";
        String javaVersion = "unknown";
        try {
            arch = System.getProperty("os.arch");
            javaVersion = System.getProperty("java.version");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return MessageFormat.format("NewRelic-JavaAgent/{0} (java {1} {2})", Agent.getVersion(), javaVersion, arch);
    }

    public DataSenderImpl(AgentConfig config) {
        this(config, null);
    }

    public DataSenderImpl(AgentConfig config, DataSenderListener dataSenderListener) {
        this.auditMode = config.isAuditMode();
        this.auditModeEndpoints = config.getAuditModeConfig().getEndpoints();
        Agent.LOG.info(MessageFormat.format("Setting audit_mode to {0}", this.auditMode));
        this.host = config.getHost();
        this.port = config.getPort();
        this.useSSL = config.isSSL();
        this.protocol = this.useSSL ? "https" : "http";
        String msg = MessageFormat.format("Setting protocol to \"{0}\"", this.protocol);
        Agent.LOG.info(msg);
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        String proxyScheme = config.getProxyScheme();
        this.usePrivateSSL = config.isUsePrivateSSL();
        this.caBundlePath = config.getCaBundlePath();
        this.sslContext = this.createSSLContext();
        if (proxyHost != null && proxyPort != null) {
            msg = MessageFormat.format("Using proxy host {0}:{1}", proxyHost, Integer.toString(proxyPort));
            Agent.LOG.fine(msg);
            this.proxy = new HttpHost(proxyHost, (int)proxyPort, proxyScheme);
            this.proxyCredentials = this.getProxyCredentials(config.getProxyUser(), config.getProxyPassword());
        } else {
            this.proxy = null;
            this.proxyCredentials = null;
        }
        this.defaultTimeoutInMillis = config.getProperty(TIMEOUT_PROPERTY, 120) * 1000;
        String licenseKeyUri = MessageFormat.format(LICENSE_KEY_URI_PATTERN, config.getLicenseKey());
        this.noAgentRunIdUriPattern = BEFORE_LICENSE_KEY_URI_PATTERN + licenseKeyUri + AFTER_LICENSE_KEY_URI_PATTERN + 16;
        this.agentRunIdUriPattern = this.noAgentRunIdUriPattern + RUN_ID_PATTERN;
        this.dataSenderListener = dataSenderListener;
        this.compressedEncoding = config.getCompressedContentEncoding();
        this.putForDataSend = config.isPutForDataSend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String caBundlePath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        InputStream in = DataSenderImpl.class.getResourceAsStream("/nrcerts");
        if (null == in) {
            Agent.LOG.fine("Unable to find NR trust store");
        } else {
            LinkedList<X509Certificate> caCerts = new LinkedList<X509Certificate>();
            if (caBundlePath != null) {
                Agent.LOG.log(Level.FINEST, "Checking ca_bundle_path at: {0}", caBundlePath);
                try (FileInputStream is = new FileInputStream(caBundlePath);){
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    while (((InputStream)is).available() > 0) {
                        try {
                            caCerts.add((X509Certificate)cf.generateCertificate(is));
                        }
                        catch (Throwable t) {
                            Agent.LOG.log(Level.FINEST, "Unable to generate ca_bundle_path certificate", t);
                        }
                    }
                }
                Agent.LOG.log(Level.FINEST, "Found: {0} certificates", caCerts.size());
            }
            try {
                keystore.load(in, null);
                int i = 1;
                for (X509Certificate caCert : caCerts) {
                    if (caCert != null) {
                        String alias = "ca_bundle_path_" + i;
                        keystore.setCertificateEntry(alias, caCert);
                        Agent.LOG.log(Level.FINEST, "Installed certificate {0} at alias: {1}", i, alias);
                        if (Agent.isDebugEnabled()) {
                            Agent.LOG.log(Level.FINEST, "Installed certificate {0} at alias: {1}", caCert, alias);
                        }
                    }
                    ++i;
                }
            }
            finally {
                in.close();
            }
        }
        Agent.LOG.finer("SSL Keystore Provider: " + keystore.getProvider().getName());
        return keystore;
    }

    private SSLContext createSSLContext() {
        SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
        try {
            if (this.usePrivateSSL && this.useSSL) {
                sslContextBuilder.loadTrustMaterial(DataSenderImpl.getKeyStore(this.caBundlePath));
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            Agent.LOG.log(Level.WARNING, e, "Unable to create SSL context");
            return null;
        }
    }

    private Credentials getProxyCredentials(String proxyUser, String proxyPass) {
        if (proxyUser != null && proxyPass != null) {
            Agent.LOG.info(MessageFormat.format("Setting Proxy Authenticator for user '{0}'", proxyUser));
            return new UsernamePasswordCredentials(proxyUser, proxyPass);
        }
        return null;
    }

    private void checkAuditMode() {
        Set<String> auditModeEndpoints2;
        boolean auditMode2 = ServiceFactory.getConfigService().getLocalAgentConfig().isAuditMode();
        if (this.auditMode != auditMode2) {
            this.auditMode = auditMode2;
            Agent.LOG.info(MessageFormat.format("Setting audit_mode to {0}", this.auditMode));
        }
        if (this.auditModeEndpoints != (auditModeEndpoints2 = ServiceFactory.getConfigService().getLocalAgentConfig().getAuditModeConfig().getEndpoints())) {
            this.auditModeEndpoints = auditModeEndpoints2;
            Agent.LOG.info(MessageFormat.format("Setting audit_mode.endpoints to {0}", this.auditModeEndpoints));
        }
    }

    @VisibleForTesting
    void setAgentRunId(Object runId) {
        this.agentRunId = runId;
        if (runId != NO_AGENT_RUN_ID) {
            Agent.LOG.info("Agent run id: " + runId);
        }
    }

    @Override
    public Map<String, Object> connect(Map<String, Object> startupOptions) throws Exception {
        String redirectHost = this.parsePreconnectAndReturnHost();
        if (redirectHost != null) {
            this.host = redirectHost;
            String msg = MessageFormat.format("Collector redirection to {0}:{1}", this.host, Integer.toString(this.port));
            Agent.LOG.info(msg);
        } else if (ServiceFactory.getConfigService().getDefaultAgentConfig().laspEnabled()) {
            throw new ForceDisconnectException("The agent did not receive one or more security policies that it expected and will shut down. Please contact support.");
        }
        return this.doConnect(startupOptions);
    }

    private String parsePreconnectAndReturnHost() throws Exception {
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        JSONObject token = new JSONObject();
        if (agentConfig.laspEnabled()) {
            token.put("security_policies_token", agentConfig.securityPoliciesToken());
        }
        params.add(token);
        Object response = this.invokeNoRunId(GET_PRECONNECT_HOST_METHOD, this.compressedEncoding, params);
        if (response != null) {
            Map returnValue = (Map)response;
            String host = returnValue.get(REDIRECT_HOST).toString();
            JSONObject policies = (JSONObject)returnValue.get(SECURITY_POLICIES);
            this.policiesJson = LaspPolicies.validatePolicies(policies);
            return host;
        }
        return null;
    }

    private Map<String, Object> doConnect(Map<String, Object> startupOptions) throws Exception {
        Object maxPayloadSize;
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        if (this.policiesJson != null && !this.policiesJson.isEmpty()) {
            startupOptions.put(SECURITY_POLICIES, LaspPolicies.convertToConnectPayload(this.policiesJson));
        }
        params.add(startupOptions);
        Object response = this.invokeNoRunId(CONNECT_METHOD, this.compressedEncoding, params);
        if (!(response instanceof Map)) {
            String msg = MessageFormat.format("Expected a map of connection data, got {0}", response);
            throw new UnexpectedException(msg);
        }
        Map data = (Map)response;
        if (data.containsKey(MAX_PAYLOAD_SIZE_IN_BYTES) && (maxPayloadSize = data.get(MAX_PAYLOAD_SIZE_IN_BYTES)) instanceof Number) {
            this.maxPayloadSizeInBytes = ((Number)maxPayloadSize).intValue();
            Agent.LOG.log(Level.INFO, "Max payload size is {0} bytes", this.maxPayloadSizeInBytes);
        }
        if (!data.containsKey(AGENT_RUN_ID_KEY)) {
            String msg = MessageFormat.format("Missing {0} connection parameter", AGENT_RUN_ID_KEY);
            throw new UnexpectedException(msg);
        }
        Object runId = data.get(AGENT_RUN_ID_KEY);
        this.setAgentRunId(runId);
        Object ssl = data.get(SSL_KEY);
        if (Boolean.TRUE.equals(ssl)) {
            Agent.LOG.info("Setting protocol to \"https\"");
            this.protocol = "https";
        }
        ServiceFactory.getConfigService().setLaspPolicies(this.policiesJson);
        return data;
    }

    @Override
    public List<List<?>> getAgentCommands() throws Exception {
        this.checkAuditMode();
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID) {
            return Collections.emptyList();
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        params.add(runId);
        Object response = this.invokeRunId(GET_AGENT_COMMANDS_METHOD, this.compressedEncoding, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return Collections.emptyList();
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Invalid response from New Relic when getting agent commands: {0}", e);
            Agent.LOG.warning(msg);
            throw e;
        }
    }

    @Override
    public List<?> getXRayParameters(Collection<Long> ids) throws Exception {
        if (ids.size() > 0) {
            this.checkAuditMode();
            Object runId = this.agentRunId;
            if (runId == NO_AGENT_RUN_ID) {
                return Collections.emptyList();
            }
            JSONArray params = new JSONArray();
            params.add(runId);
            for (Long s : ids) {
                params.add(s);
            }
            Object response = this.invokeRunId(GET_XRAY_PARMS_METHOD, this.compressedEncoding, runId, params);
            if (response == null || NULL_RESPONSE.equals(response)) {
                return Collections.emptyList();
            }
            try {
                return (List)response;
            }
            catch (ClassCastException e) {
                String msg = MessageFormat.format("Invalid response from New Relic when getting agent X Ray parameters: {0}", e);
                Agent.LOG.warning(msg);
                throw e;
            }
        }
        Agent.LOG.info("Attempted to fetch X-Ray Session metadata with no session IDs");
        return Collections.emptyList();
    }

    @Override
    public void sendCommandResults(Map<Long, Object> commandResults) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || commandResults.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(commandResults);
        this.invokeRunId(AGENT_COMMAND_RESULTS_METHOD, this.compressedEncoding, runId, params);
    }

    @Override
    public void sendErrorData(List<TracedError> errors) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || errors.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(errors);
        this.invokeRunId(ERROR_DATA_METHOD, this.compressedEncoding, runId, params);
    }

    @Override
    public void sendErrorEvents(int reservoirSize, int eventsSeen, Collection<ErrorEvent> errorEvents) throws Exception {
        this.sendAnalyticEventsForReservoir(ERROR_EVENT_DATA_METHOD, this.compressedEncoding, reservoirSize, eventsSeen, errorEvents);
    }

    @Override
    public void sendAnalyticsEvents(int reservoirSize, int eventsSeen, Collection<? extends AnalyticsEvent> events) throws Exception {
        this.sendAnalyticEventsForReservoir(ANALYTIC_DATA_METHOD, this.compressedEncoding, reservoirSize, eventsSeen, events);
    }

    @Override
    public void sendCustomAnalyticsEvents(int reservoirSize, int eventsSeen, Collection<? extends CustomInsightsEvent> events) throws Exception {
        this.sendAnalyticEventsForReservoir(CUSTOM_ANALYTIC_DATA_METHOD, this.compressedEncoding, reservoirSize, eventsSeen, events);
    }

    @Override
    public void sendSpanEvents(int reservoirSize, int eventsSeen, Collection<SpanEvent> events) throws Exception {
        this.sendAnalyticEventsForReservoir(SPAN_EVENT_DATA_METHOD, this.compressedEncoding, reservoirSize, eventsSeen, events);
    }

    private void sendAnalyticEventsForReservoir(String method, String encoding, int reservoirSize, int eventsSeen, Collection<? extends AnalyticsEvent> events) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || events.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(3);
        params.add(runId);
        JSONObject metadata = new JSONObject();
        metadata.put("reservoir_size", reservoirSize);
        metadata.put("events_seen", eventsSeen);
        params.add(metadata);
        params.add(events);
        this.invokeRunId(method, encoding, runId, params);
    }

    @Override
    public List<List<?>> sendMetricData(long beginTimeMillis, long endTimeMillis, List<MetricData> metricData) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || metricData.isEmpty()) {
            return Collections.emptyList();
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(4);
        params.add(runId);
        params.add(beginTimeMillis / 1000L);
        params.add(endTimeMillis / 1000L);
        params.add(metricData);
        Object response = this.invokeRunId(METRIC_DATA_METHOD, this.compressedEncoding, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            throw new MetricDataException("Invalid null response sending metric data");
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Invalid response from New Relic when sending metric data: {0}", e);
            Agent.LOG.warning(msg);
            throw e;
        }
    }

    @Override
    public List<Long> sendProfileData(List<ProfileData> profiles) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || profiles.isEmpty()) {
            return Collections.emptyList();
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(profiles);
        Object response = this.invokeRunId(PROFILE_DATA_METHOD, this.getEncodingForComplexCompression(), runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return Collections.emptyList();
        }
        try {
            return (List)response;
        }
        catch (ClassCastException e) {
            String msg = MessageFormat.format("Invalid response from New Relic sending profiles: {0}", e);
            Agent.LOG.warning(msg);
            throw e;
        }
    }

    @Override
    public void sendModules(List<Jar> pJars) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || pJars == null || pJars.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(MODULE_TYPE);
        params.add(pJars);
        Object response = this.invokeRunId(UPDATE_LOADED_MODULES_METHOD, this.compressedEncoding, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return;
        }
        String msg = MessageFormat.format("Invalid response from New Relic when sending modules. Response: {0}", response);
        Agent.LOG.warning(msg);
    }

    private String getEncodingForComplexCompression() {
        return ServiceFactory.getConfigService().getDefaultAgentConfig().isSimpleCompression() ? this.compressedEncoding : IDENTITY_ENCODING;
    }

    @Override
    public void sendModuleMetadata(Module module) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID) {
            throw new Exception("Not connected");
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        params.add(module);
        Object response = this.invokeRunId(MODULE_METADATA_METHOD, IDENTITY_ENCODING, runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return;
        }
        String msg = MessageFormat.format("Invalid response from New Relic when sending module data. Response: {0}", response);
        Agent.LOG.warning(msg);
    }

    @Override
    public void sendSqlTraceData(List<SqlTrace> sqlTraces) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || sqlTraces.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(1);
        params.add(sqlTraces);
        Object response = this.invokeRunId(SQL_TRACE_DATA_METHOD, this.getEncodingForComplexCompression(), runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return;
        }
        String msg = MessageFormat.format("Invalid response from New Relic when sending sql traces. Response: {0}", response);
        Agent.LOG.warning(msg);
    }

    @Override
    public void sendTransactionTraceData(List<TransactionTrace> traces) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID || traces.isEmpty()) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(traces);
        Object response = this.invokeRunId(TRANSACTION_SAMPLE_DATA_METHOD, this.getEncodingForComplexCompression(), runId, params);
        if (response == null || NULL_RESPONSE.equals(response)) {
            return;
        }
        String msg = MessageFormat.format("Invalid response from New Relic when sending transaction traces. Response: {0}", response);
        Agent.LOG.warning(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(long timeMillis) throws Exception {
        Object runId = this.agentRunId;
        if (runId == NO_AGENT_RUN_ID) {
            return;
        }
        InitialSizedJsonArray params = new InitialSizedJsonArray(2);
        params.add(runId);
        params.add(timeMillis);
        int requestTimeoutInMillis = 10000;
        try {
            this.invokeRunId(SHUTDOWN_METHOD, this.compressedEncoding, runId, requestTimeoutInMillis, params);
        }
        finally {
            this.setAgentRunId(NO_AGENT_RUN_ID);
        }
    }

    @VisibleForTesting
    void setMaxPayloadSizeInBytes(int payloadSizeInBytes) {
        this.maxPayloadSizeInBytes = payloadSizeInBytes;
    }

    private Object invokeRunId(String method, String encoding, Object runId, JSONStreamAware params) throws Exception {
        return this.invokeRunId(method, encoding, runId, this.defaultTimeoutInMillis, params);
    }

    private Object invokeRunId(String method, String encoding, Object runId, int timeoutInMillis, JSONStreamAware params) throws Exception {
        String uri = MessageFormat.format(this.agentRunIdUriPattern, method, runId.toString());
        return this.invoke(method, encoding, uri, params, timeoutInMillis);
    }

    private Object invokeNoRunId(String method, String encoding, JSONStreamAware params) throws Exception {
        String uri = MessageFormat.format(this.noAgentRunIdUriPattern, method);
        return this.invoke(method, encoding, uri, params, this.defaultTimeoutInMillis);
    }

    private Object invoke(String method, String encoding, String uri, JSONStreamAware params, int timeoutInMillis) throws Exception {
        ReadResult readResult = this.send(method, encoding, uri, params, timeoutInMillis);
        Map<?, ?> responseMap = null;
        String responseBody = readResult.getResponseBody();
        if (responseBody != null) {
            Exception ex;
            try {
                responseMap = this.getResponseMap(responseBody);
                ex = this.parseException(responseMap);
            }
            catch (Exception e) {
                Agent.LOG.log(Level.WARNING, "Error parsing response JSON({0}) from NewRelic: {1}", method, e.toString());
                Agent.LOG.log(Level.FINEST, "Invalid response JSON({0}): {1}", method, responseBody);
                throw e;
            }
            if (ex != null) {
                throw ex;
            }
        } else {
            Agent.LOG.log(Level.FINER, "Response was null ({0})", method);
        }
        if (responseMap != null) {
            if (this.dataSenderListener != null) {
                this.dataSenderListener.dataReceived(method, encoding, uri, responseMap);
            }
            try {
                return responseMap.get(EXCEPTION_MAP_RETURN_VALUE_KEY);
            }
            catch (ClassCastException ex) {
                Agent.LOG.log(Level.WARNING, "Error parsing response JSON({0}) from NewRelic: {1}", method, ex.toString());
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadResult connectAndSend(String method, String encoding, String uri, JSONStreamAware params, int timeoutInMillis) throws Exception {
        try (CloseableHttpClient conn = null;){
            ReadResult readResult;
            conn = this.createHttpClient(encoding, uri, timeoutInMillis);
            byte[] data = this.writeData(encoding, params);
            if (data.length > this.maxPayloadSizeInBytes && !method.equals(ERROR_DATA_METHOD)) {
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Agent/Collector/MaxPayloadSizeLimit/{0}", method), 1));
                String msg = MessageFormat.format("Payload of size {0} exceeded maximum size {1} for {2} method ", data.length, this.maxPayloadSizeInBytes, method);
                throw new MaxPayloadException(msg);
            }
            HttpUriRequest request = this.createRequest(encoding, uri, timeoutInMillis, data);
            HttpContext context = this.createHttpContext();
            CloseableHttpResponse response = conn.execute(request, context);
            try {
                StatusLine statusLine = response.getStatusLine();
                if (statusLine == null) {
                    throw new Exception("The http response has no status line");
                }
                if (this.auditMode && this.methodWhitelisted(method)) {
                    String msg = MessageFormat.format("Sent JSON({0}) to: {1}, with payload: {2}", method, request.getURI(), DataSenderWriter.toJSONString(params));
                    Agent.LOG.info(msg);
                }
                int statusCode = statusLine.getStatusCode();
                ServiceFactory.getStatsService().doStatsWork(StatsWorks.getIncrementCounterWork(MessageFormat.format("Supportability/Collector/HttpCode/{0}", statusCode), 1));
                if (statusCode == 407) {
                    String authField = response.getFirstHeader("Proxy-Authenticate").getValue();
                    throw new HttpError("Proxy Authentication Mechanism Failed: " + authField, statusCode, data.length);
                }
                if (statusCode != 200) {
                    Agent.LOG.log(Level.FINER, "Connection http status code: {0}", statusCode);
                    throw HttpError.create(statusCode, this.host, data.length);
                }
                String responseBody = this.readResponseBody(response);
                if (this.auditMode && this.methodWhitelisted(method)) {
                    String msg = MessageFormat.format("Received JSON({0}): {1}", method, responseBody);
                    Agent.LOG.info(msg);
                }
                if (this.dataSenderListener != null) {
                    this.dataSenderListener.dataSent(method, encoding, uri, data);
                }
                readResult = ReadResult.create(statusCode, responseBody);
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
            response.close();
            return readResult;
        }
    }

    private boolean methodWhitelisted(String method) {
        if (this.auditModeEndpoints != null && this.auditModeEndpoints.size() > 0) {
            return this.auditModeEndpoints.contains(method);
        }
        return true;
    }

    private HttpContext createHttpContext() {
        HttpClientContext context = new HttpClientContext();
        if (this.proxy != null && this.proxyCredentials != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(this.proxy), this.proxyCredentials);
            context.setCredentialsProvider(credentialsProvider);
        }
        return context;
    }

    private ReadResult send(String method, String encoding, String uri, JSONStreamAware params, int timeoutInMillis) throws Exception {
        try {
            return this.connectAndSend(method, encoding, uri, params, timeoutInMillis);
        }
        catch (MalformedURLException e) {
            Agent.LOG.log(Level.SEVERE, "You have requested a connection to New Relic via a protocol which is unavailable in your runtime: {0}", e.toString());
            throw new ForceDisconnectException(e.toString());
        }
        catch (SocketException e) {
            if (e.getCause() instanceof NoSuchAlgorithmException) {
                String msg = MessageFormat.format("You have requested a connection to New Relic via an algorithm which is unavailable in your runtime: {0}  This may also be indicative of a corrupted keystore or trust store on your server.", e.getCause().toString());
                Agent.LOG.error(msg);
            } else {
                Agent.LOG.log(Level.INFO, "A socket exception was encountered while sending data to New Relic ({0}).  Please check your network / proxy settings.", e.toString());
                if (Agent.LOG.isLoggable(Level.FINE)) {
                    Agent.LOG.log(Level.FINE, "Error sending JSON({0}): {1}", method, DataSenderWriter.toJSONString(params));
                }
                Agent.LOG.log(Level.FINEST, e, e.toString());
            }
            throw e;
        }
        catch (HttpError e) {
            throw e;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.INFO, "Remote {0} call failed : {1}.", method, e.toString());
            if (Agent.LOG.isLoggable(Level.FINE)) {
                Agent.LOG.log(Level.FINE, "Error sending JSON({0}): {1}", method, DataSenderWriter.toJSONString(params));
            }
            Agent.LOG.log(Level.FINEST, e, e.toString());
            throw e;
        }
    }

    private HttpUriRequest createRequest(String encoding, String uri, int requestTimeoutInMillis, byte[] data) throws MalformedURLException, URISyntaxException {
        URL url = new URL(this.protocol, this.host, this.port, uri);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis).setSocketTimeout(requestTimeoutInMillis).build();
        RequestBuilder requestBuilder = this.putForDataSend ? RequestBuilder.put() : RequestBuilder.post();
        requestBuilder.setUri(url.toURI()).setEntity(new ByteArrayEntity(data)).setConfig(config);
        return requestBuilder.build();
    }

    private CloseableHttpClient createHttpClient(String encoding, String uri, int requestTimeoutInMillis) throws Exception {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setUserAgent(USER_AGENT_HEADER_VALUE).setDefaultHeaders(Arrays.asList(new BasicHeader("Connection", "Keep-Alive"), new BasicHeader("CONTENT-TYPE", "application/json"), new BasicHeader("ACCEPT-ENCODING", "gzip"), new BasicHeader("CONTENT-ENCODING", encoding)));
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(requestTimeoutInMillis).setSoKeepAlive(true).build());
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setConnectTimeout(requestTimeoutInMillis).setConnectionRequestTimeout(requestTimeoutInMillis).setSocketTimeout(requestTimeoutInMillis);
        builder.setDefaultRequestConfig(requestBuilder.build());
        builder.setHostnameVerifier(new StrictHostnameVerifier());
        if (this.proxy != null) {
            builder.setProxy(this.proxy);
        }
        if (this.sslContext != null) {
            builder.setSSLSocketFactory(new SSLConnectionSocketFactory(this.sslContext));
        }
        CloseableHttpClient httpClient = builder.build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeData(String encoding, JSONStreamAware params) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try (Writer out = null;){
            OutputStream os = this.getOutputStream(outStream, encoding);
            out = new OutputStreamWriter(os, "UTF-8");
            JSONValue.writeJSONString(params, out);
            out.flush();
        }
        return outStream.toByteArray();
    }

    private OutputStream getOutputStream(OutputStream out, String encoding) throws IOException {
        if (DEFLATE_ENCODING.equals(encoding)) {
            return new DeflaterOutputStream(out, new Deflater(-1));
        }
        if ("gzip".equals(encoding)) {
            return new GZIPOutputStream(out);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readResponseBody(CloseableHttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new Exception("The http response entity was null");
        }
        InputStream is = entity.getContent();
        BufferedReader in = this.getBufferedReader(response, is);
        try {
            String line;
            StringBuilder responseBody = new StringBuilder();
            while ((line = in.readLine()) != null) {
                responseBody.append(line);
            }
            String string = responseBody.toString();
            return string;
        }
        finally {
            in.close();
            is.close();
        }
    }

    private Map<?, ?> getResponseMap(String responseBody) throws Exception {
        JSONParser parser = new JSONParser();
        Object response = parser.parse(responseBody);
        return (Map)Map.class.cast(response);
    }

    private BufferedReader getBufferedReader(CloseableHttpResponse response, InputStream is) throws IOException {
        String encoding;
        Header encodingHeader = response.getFirstHeader("content-encoding");
        if (encodingHeader != null && "gzip".equals(encoding = encodingHeader.getValue())) {
            is = new GZIPInputStream(is);
        }
        return new BufferedReader(new InputStreamReader(is, "UTF-8"));
    }

    private Exception parseException(Map<?, ?> responseMap) throws Exception {
        String message;
        Object exception = responseMap.get(RESPONSE_MAP_EXCEPTION_KEY);
        if (exception == null) {
            return null;
        }
        Map exceptionMap = (Map)Map.class.cast(exception);
        try {
            message = (String)exceptionMap.get(EXCEPTION_MAP_MESSAGE_KEY);
        }
        catch (Exception e) {
            message = exceptionMap.toString();
        }
        String type = (String)exceptionMap.get(EXCEPTION_MAP_ERROR_TYPE_KEY);
        Class<Exception> clazz = RubyConversion.rubyClassToJavaClass(type);
        Constructor<Exception> constructor = clazz.getConstructor(String.class);
        return constructor.newInstance(message);
    }
}

