/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracers.servlet;

import com.newrelic.agent.Agent;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracers.servlet.QueueTimeTracker;
import com.newrelic.api.agent.Request;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ExternalTimeTracker {
    static final long EARLIEST_ACCEPTABLE_TIMESTAMP_NANO = 946684800000000000L;
    static final List<Integer> MAGNITUDES = Arrays.asList(1, 1000, 1000000, 1000000000);
    private final QueueTimeTracker queueTimeTracker;
    private final long externalTime;

    private ExternalTimeTracker(Request httpRequest, long txStartTimeInMillis) {
        if (httpRequest == null) {
            Agent.LOG.finer("Unable to get headers: HttpRequest is null");
        }
        long txStartTimeInNanos = ExternalTimeTracker.parseTimestampToNano(txStartTimeInMillis);
        this.queueTimeTracker = QueueTimeTracker.create(httpRequest, txStartTimeInNanos);
        long queueTime = this.queueTimeTracker.getQueueTime();
        this.externalTime = TimeUnit.MILLISECONDS.convert(queueTime, TimeUnit.NANOSECONDS);
    }

    public long getExternalTime() {
        return this.externalTime;
    }

    public void recordMetrics(TransactionStats statsEngine) {
        this.queueTimeTracker.recordMetrics(statsEngine);
    }

    protected static String getRequestHeader(Request httpRequest, String headerName) {
        if (httpRequest == null) {
            return null;
        }
        try {
            String header = httpRequest.getHeader(headerName);
            if (header != null && Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Got {0} header: {1}", headerName, header);
                Agent.LOG.finer(msg);
            }
            return header;
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Error getting {0} header: {1}", headerName, t.toString());
            if (Agent.LOG.isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, msg, t);
            } else {
                Agent.LOG.finer(msg);
            }
            return null;
        }
    }

    public static ExternalTimeTracker create(Request httpRequest, long txStartTimeInMillis) {
        return new ExternalTimeTracker(httpRequest, txStartTimeInMillis);
    }

    public static long parseTimestampToNano(String strTime) throws NumberFormatException {
        double time = Double.parseDouble(strTime);
        return ExternalTimeTracker.parseTimestampToNano(time);
    }

    public static long parseTimestampToNano(double time) throws NumberFormatException {
        if (time > 0.0) {
            Iterator<Integer> iterator = MAGNITUDES.iterator();
            while (iterator.hasNext()) {
                long magnitude = iterator.next().intValue();
                long candidate = (long)(time * (double)magnitude);
                if (946684800000000000L >= candidate || candidate >= 4954167440812867584L) continue;
                return candidate;
            }
        }
        throw new NumberFormatException("The long " + time + " could not be converted to a timestamp in nanoseconds (wrong magnitude).");
    }
}

