/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.stats;

import com.newrelic.agent.deps.com.google.common.util.concurrent.AtomicDouble;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsBase;

public class StatsImpl
extends AbstractStats
implements Stats {
    private final AtomicDouble total;
    private final AtomicDouble minValue;
    private final AtomicDouble maxValue;
    private final AtomicDouble sumOfSquares;

    protected StatsImpl() {
        this(0, 0.0f, 0.0f, 0.0f, 0.0);
    }

    public StatsImpl(int count, float total, float minValue, float maxValue, double sumOfSquares) {
        super(count);
        this.total = new AtomicDouble(total);
        this.minValue = new AtomicDouble(minValue);
        this.maxValue = new AtomicDouble(maxValue);
        this.sumOfSquares = new AtomicDouble(sumOfSquares);
    }

    private StatsImpl(int count, double total, double minValue, double maxValue, double sumOfSquares) {
        super(count);
        this.total = new AtomicDouble(total);
        this.minValue = new AtomicDouble(minValue);
        this.maxValue = new AtomicDouble(maxValue);
        this.sumOfSquares = new AtomicDouble(sumOfSquares);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new StatsImpl(this.count.get(), this.total.get(), this.minValue.get(), this.maxValue.get(), this.sumOfSquares.get());
    }

    public String toString() {
        return super.toString() + " [tot=" + this.total + ", min=" + this.minValue + ", maxV=" + this.maxValue + "]";
    }

    @Override
    public void recordDataPoint(float value) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw new IllegalArgumentException("Data points must be numbers");
        }
        double sumOfSquares = this.sumOfSquares.get();
        double sos = sumOfSquares + (double)(value * value);
        if (sos < sumOfSquares) {
            throw new IllegalArgumentException("Data value " + value + " caused sum of squares to roll over");
        }
        if (this.count.get() > 0) {
            this.minValue.set(Math.min((double)value, this.minValue.get()));
        } else {
            this.minValue.set(value);
        }
        this.count.incrementAndGet();
        this.total.addAndGet(value);
        this.maxValue.set(Math.max((double)value, this.maxValue.get()));
        this.sumOfSquares.set(sos);
    }

    @Override
    public boolean hasData() {
        return this.count.get() > 0 || this.total.get() > 0.0;
    }

    @Override
    public void reset() {
        this.count.set(0);
        this.total.set(0.0);
        this.minValue.set(0.0);
        this.maxValue.set(0.0);
        this.sumOfSquares.set(0.0);
    }

    @Override
    public float getTotal() {
        return (float)this.total.get();
    }

    @Override
    public float getTotalExclusiveTime() {
        return (float)this.total.get();
    }

    @Override
    public float getMinCallTime() {
        return (float)this.minValue.get();
    }

    @Override
    public float getMaxCallTime() {
        return (float)this.maxValue.get();
    }

    @Override
    public double getSumOfSquares() {
        return this.sumOfSquares.get();
    }

    @Override
    public void merge(StatsBase statsObj) {
        if (statsObj instanceof StatsImpl) {
            StatsImpl stats = (StatsImpl)statsObj;
            if (stats.count.get() > 0) {
                if (this.count.get() > 0) {
                    this.minValue.set(Math.min(this.minValue.get(), stats.minValue.get()));
                } else {
                    this.minValue.set(stats.minValue.get());
                }
            }
            this.count.addAndGet(stats.count.get());
            this.total.addAndGet(stats.total.get());
            this.maxValue.set(Math.max(this.maxValue.get(), stats.maxValue.get()));
            this.sumOfSquares.addAndGet(stats.sumOfSquares.get());
        }
    }
}

