/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile.v2;

import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.org.json.simple.JSONStreamAware;
import com.newrelic.agent.profile.v2.ProfiledMethod;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class ProfileSegment
implements JSONStreamAware {
    protected final ProfiledMethod method;
    protected final ConcurrentMap<ProfiledMethod, ProfileSegment> children;

    public ProfileSegment(ProfiledMethod method) {
        this.method = method;
        this.children = Maps.newConcurrentMap();
    }

    public final Set<ProfiledMethod> getMethods() {
        HashSet<ProfiledMethod> methods = new HashSet<ProfiledMethod>();
        methods.add(this.getMethod());
        for (ProfileSegment kid : this.children.values()) {
            methods.addAll(kid.getMethods());
        }
        return methods;
    }

    public final Collection<ProfileSegment> getChildren() {
        return this.children.values();
    }

    Map<ProfiledMethod, ProfileSegment> getChildMap() {
        return this.children;
    }

    public final ProfiledMethod getMethod() {
        return this.method;
    }

    protected final void removeChild(ProfiledMethod method) {
        this.children.remove(method);
    }

    public final <P extends ProfileSegment> P addChild(ProfiledMethod method) {
        ProfileSegment previous;
        ProfileSegment result = (ProfileSegment)this.children.get(method);
        if (result == null && null != (previous = this.children.putIfAbsent(method, result = this.createProfileSegment(method)))) {
            return (P)previous;
        }
        return (P)result;
    }

    protected abstract <P extends ProfileSegment> P createProfileSegment(ProfiledMethod var1);

    public abstract int getCallCount(ProfiledMethod var1);

    public abstract int getCallSiteCount();

    public abstract void incrementCallCount(boolean var1);

    protected abstract int getRunnableCallCount();
}

