/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.profile;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.commands.AbstractCommand;
import com.newrelic.agent.commands.CommandException;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.profile.ProfilerControl;
import com.newrelic.agent.profile.ProfilerParameters;
import com.newrelic.agent.util.TimeConversion;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StartProfilerCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "start_profiler";
    private static final String DISABLED_MESSAGE = "The profiler service is disabled";
    private static final String DURATION = "duration";
    private static final String SAMPLE_PERIOD = "sample_period";
    private static final String PROFILE_ID = "profile_id";
    private static final String ONLY_RUNNABLE_THREADS = "only_runnable_threads";
    private static final String ONLY_REQUEST_THREADS = "only_request_threads";
    private static final String PROFILE_AGENT_CODE = "profile_agent_code";
    private static final String PROFILER_FORMAT = "profiler_format";
    private static final String PROFILE_INSTRUMENTATION = "profile_instrumentation";
    private static final boolean DEFAULT_ONLY_RUNNABLE_THREADS = false;
    private static final boolean DEFAULT_ONLY_REQUEST_THREADS = false;
    private final ProfilerControl profilerControl;

    public StartProfilerCommand(ProfilerControl profilerControl) {
        super(COMMAND_NAME);
        this.profilerControl = profilerControl;
    }

    @Override
    public Map<?, ?> process(IRPMService rpmService, Map arguments) throws CommandException {
        if (this.profilerControl.isEnabled()) {
            return this.processEnabled(rpmService, arguments);
        }
        return this.processDisabled(rpmService, arguments);
    }

    public Map<?, ?> processEnabled(IRPMService rpmService, Map<?, ?> arguments) throws CommandException {
        ProfilerParameters parameters = this.createProfilerParameters(arguments);
        this.profilerControl.startProfiler(parameters);
        return Collections.EMPTY_MAP;
    }

    public Map<?, ?> processDisabled(IRPMService rpmService, Map<?, ?> arguments) throws CommandException {
        Agent.LOG.info(DISABLED_MESSAGE);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("error", DISABLED_MESSAGE);
        return result;
    }

    private ProfilerParameters createProfilerParameters(Map<?, ?> arguments) throws CommandException {
        double duration;
        HashMap<?, ?> argCopy = Maps.newHashMap(arguments);
        long profileId = this.getProfileId(arguments);
        double samplePeriod = this.getSamplePeriod(arguments);
        if (samplePeriod > (duration = this.getDuration(arguments))) {
            String msg = MessageFormat.format("{0} > {1} in start_profiler command: {2} > {3}", SAMPLE_PERIOD, DURATION, samplePeriod, duration);
            throw new CommandException(msg);
        }
        long samplePeriodInMillis = TimeConversion.convertSecondsToMillis(samplePeriod);
        long durationInMillis = TimeConversion.convertSecondsToMillis(duration);
        boolean onlyRunnableThreads = this.getOnlyRunnableThreads(arguments);
        boolean onlyRequestThreads = this.getOnlyRequestThreads(arguments);
        boolean profileAgentCode = this.getProfileAgentCode(arguments);
        String profilerFormat = (String)arguments.remove(PROFILER_FORMAT);
        Boolean profileInstrumentation = (Boolean)arguments.remove(PROFILE_INSTRUMENTATION);
        if (arguments.size() > 0) {
            String msg = MessageFormat.format("Unexpected arguments in start_profiler command: {0}", arguments.keySet().toString());
            Agent.LOG.warning(msg);
        }
        return new ProfilerParameters(profileId, samplePeriodInMillis, durationInMillis, onlyRunnableThreads, onlyRequestThreads, profileAgentCode, null, null, null).setProfilerFormat(profilerFormat).setProfileInstrumentation(profileInstrumentation).setParameterMap(argCopy);
    }

    private long getProfileId(Map<?, ?> arguments) throws CommandException {
        Object profileId = arguments.remove(PROFILE_ID);
        if (profileId instanceof Number) {
            return ((Number)profileId).longValue();
        }
        if (profileId == null) {
            String msg = MessageFormat.format("Missing {0} in start_profiler command", PROFILE_ID);
            throw new CommandException(msg);
        }
        String msg = MessageFormat.format("Invalid {0} in start_profiler command: {1}", PROFILE_ID, profileId);
        throw new CommandException(msg);
    }

    private double getSamplePeriod(Map<?, ?> arguments) throws CommandException {
        Object samplePeriod = arguments.remove(SAMPLE_PERIOD);
        if (samplePeriod instanceof Number) {
            return ((Number)samplePeriod).doubleValue();
        }
        if (samplePeriod == null) {
            String msg = MessageFormat.format("Missing {0} in start_profiler command", SAMPLE_PERIOD);
            throw new CommandException(msg);
        }
        String msg = MessageFormat.format("Invalid {0} in start_profiler command: {1}", SAMPLE_PERIOD, samplePeriod);
        throw new CommandException(msg);
    }

    private double getDuration(Map<?, ?> arguments) throws CommandException {
        Object duration = arguments.remove(DURATION);
        if (duration instanceof Number) {
            return ((Number)duration).doubleValue();
        }
        if (duration == null) {
            String msg = MessageFormat.format("Missing {0} in start_profiler command", DURATION);
            throw new CommandException(msg);
        }
        String msg = MessageFormat.format("Invalid {0} in start_profiler command: {1}", DURATION, duration);
        throw new CommandException(msg);
    }

    private boolean getOnlyRunnableThreads(Map<?, ?> arguments) throws CommandException {
        Object onlyRunnableThreads = arguments.remove(ONLY_RUNNABLE_THREADS);
        if (onlyRunnableThreads instanceof Boolean) {
            return (Boolean)onlyRunnableThreads;
        }
        if (onlyRunnableThreads == null) {
            return false;
        }
        String msg = MessageFormat.format("Invalid {0} in start_profiler command: {1}", ONLY_RUNNABLE_THREADS, onlyRunnableThreads);
        throw new CommandException(msg);
    }

    private boolean getOnlyRequestThreads(Map<?, ?> arguments) throws CommandException {
        Object onlyRequestThreads = arguments.remove(ONLY_REQUEST_THREADS);
        if (onlyRequestThreads instanceof Boolean) {
            return (Boolean)onlyRequestThreads;
        }
        if (onlyRequestThreads == null) {
            return false;
        }
        String msg = MessageFormat.format("Invalid {0} in start_profiler command: {1}", ONLY_REQUEST_THREADS, onlyRequestThreads);
        throw new CommandException(msg);
    }

    private boolean getProfileAgentCode(Map<?, ?> arguments) throws CommandException {
        Object profileAgentCode = arguments.remove(PROFILE_AGENT_CODE);
        if (profileAgentCode instanceof Boolean) {
            return (Boolean)profileAgentCode;
        }
        if (profileAgentCode == null) {
            return Agent.isDebugEnabled();
        }
        String msg = MessageFormat.format("Invalid {0} in start_profiler command: {1}", PROFILE_AGENT_CODE, profileAgentCode);
        throw new CommandException(msg);
    }
}

